package ch.njol.skript.events;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser.ParseResult;
import io.papermc.paper.event.block.BeaconActivatedEvent;
import io.papermc.paper.event.block.BeaconDeactivatedEvent;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

public class EvtBeaconToggle extends SkriptEvent {

	static {
		if (Skript.classExists("io.papermc.paper.event.block.BeaconActivatedEvent"))
			Skript.registerEvent("Beacon Toggle", EvtBeaconToggle.class, new Class[] {BeaconActivatedEvent.class, BeaconDeactivatedEvent.class},
					"beacon toggle",
					"beacon activat(e|ion)",
					"beacon deactivat(e|ion)")
				.description("Called when a beacon is activated or deactivated.")
				.examples(
					"on beacon toggle:",
					"on beacon activate:",
					"on beacon deactivate:"
				)
				.since("2.10");
	}

	private boolean isActivate, isToggle;

	@Override
    public boolean init(Literal<?>[] exprs, int matchedPattern, ParseResult parseResult) {
		isToggle = matchedPattern == 0;
		isActivate = matchedPattern == 1;
		return true;
	}

	@Override
	public boolean check(Event event) {
		if (!isToggle) {
			if (event instanceof BeaconActivatedEvent) {
				return isActivate;
			} else if (event instanceof BeaconDeactivatedEvent) {
				return !isActivate;
			}
		}
		return true;
	}

	@Override
	public String toString(@Nullable Event event, boolean debug) {
		return "beacon " + (isToggle ? "toggle" : isActivate ? "activate" : "deactivate");
	}

}
