/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.classes;

import ch.njol.skript.lang.Expression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Changer<T> {
    public Class<?> @Nullable [] acceptChange(ChangeMode var1);

    public void change(T[] var1, Object @Nullable [] var2, ChangeMode var3);

    public static abstract class ChangerUtils {
        public static <T> void change(@NotNull Changer<T> changer, Object[] what, Object @Nullable [] delta, ChangeMode mode) {
            changer.change(what, delta, mode);
        }

        public static boolean acceptsChange(@NotNull Expression<?> expression, ChangeMode mode, Class<?> ... types) {
            Class<?>[] validTypes = expression.acceptChange(mode);
            if (validTypes == null) {
                return false;
            }
            for (int i = 0; i < validTypes.length; ++i) {
                if (!validTypes[i].isArray()) continue;
                validTypes[i] = validTypes[i].getComponentType();
            }
            return ChangerUtils.acceptsChangeTypes(validTypes, types);
        }

        public static boolean acceptsChangeTypes(Class<?>[] validTypes, Class<?> ... types) {
            for (Class<?> type : types) {
                for (Class<?> validType : validTypes) {
                    if (!validType.isAssignableFrom(type)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    public static enum ChangeMode {
        ADD,
        SET,
        REMOVE,
        REMOVE_ALL,
        DELETE,
        RESET;


        public boolean supportsKeyedChange() {
            return this == SET;
        }
    }
}

