/*
 * Decompiled with CFR 0.152.
 */
package org.skriptlang.skript.bukkit.misc.expressions;

import ch.njol.skript.ServerPlatform;
import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.util.chat.BungeeConverter;
import ch.njol.skript.util.chat.ChatMessages;
import ch.njol.util.coll.CollectionUtils;
import java.util.Arrays;
import net.kyori.adventure.text.serializer.bungeecord.BungeeComponentSerializer;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.entity.TextDisplay;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Text Of")
@Description(value={"Returns or changes the <a href='#string'>text/string</a> of <a href='#display'>displays</a>.", "Note that currently you can only use Skript chat codes when running Paper."})
@Examples(value={"set text of the last spawned text display to \"example\""})
@Since(value={"2.10"})
public class ExprTextOf
extends SimplePropertyExpression<Object, String> {
    private static final boolean IS_RUNNING_PAPER = Skript.getServerPlatform() == ServerPlatform.BUKKIT_PAPER;
    private static BungeeComponentSerializer serializer;

    @Override
    @Nullable
    public String convert(Object object) {
        if (object instanceof TextDisplay) {
            TextDisplay textDisplay = (TextDisplay)object;
            return textDisplay.getText();
        }
        return null;
    }

    @Override
    public Class<?> @Nullable [] acceptChange(Changer.ChangeMode mode) {
        return switch (mode) {
            case Changer.ChangeMode.RESET -> CollectionUtils.array(new Class[0]);
            case Changer.ChangeMode.SET -> CollectionUtils.array(String[].class);
            default -> null;
        };
    }

    @Override
    public void change(Event event, Object @Nullable [] delta, Changer.ChangeMode mode) {
        String value = delta == null ? null : String.join((CharSequence)"\n", (CharSequence[])Arrays.copyOf(delta, delta.length, String[].class));
        for (Object object : this.getExpr().getArray(event)) {
            if (!(object instanceof TextDisplay)) continue;
            TextDisplay textDisplay = (TextDisplay)object;
            if (IS_RUNNING_PAPER && serializer != null && value != null) {
                BaseComponent[] components = BungeeConverter.convert(ChatMessages.parseToArray(value));
                textDisplay.text(serializer.deserialize(components));
                continue;
            }
            textDisplay.setText(value);
        }
    }

    @Override
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @Override
    protected String getPropertyName() {
        return "text";
    }

    static {
        Object types = "";
        if (Skript.classExists("org.bukkit.entity.Display")) {
            if (IS_RUNNING_PAPER) {
                serializer = BungeeComponentSerializer.get();
            }
            types = (String)types + "displays";
        }
        if (!((String)types).isEmpty()) {
            ExprTextOf.register(ExprTextOf.class, String.class, "text[s]", (String)types);
        }
    }
}

