/*
 * Decompiled with CFR 0.152.
 */
package org.skriptlang.skript.common.function;

import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public interface Parameter<T> {
    @NotNull
    public String name();

    @NotNull
    public Class<T> type();

    public @Unmodifiable @NotNull Set<Modifier> modifiers();

    default public boolean hasModifier(Modifier modifier) {
        return this.modifiers().contains(modifier);
    }

    default public boolean single() {
        return !this.type().isArray();
    }

    public static interface Modifier {
        public static final Modifier OPTIONAL = Modifier.of();
        public static final Modifier KEYED = Modifier.of();

        public static Modifier of() {
            return new Modifier(){};
        }
    }
}

