/*
 * Decompiled with CFR 0.152.
 */
package org.skriptlang.skript.log.runtime;

import ch.njol.skript.Skript;
import ch.njol.skript.log.SkriptLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;
import org.skriptlang.skript.log.runtime.Frame;
import org.skriptlang.skript.log.runtime.RuntimeError;
import org.skriptlang.skript.log.runtime.RuntimeErrorConsumer;
import org.skriptlang.skript.log.runtime.RuntimeErrorFilter;
import org.skriptlang.skript.log.runtime.RuntimeErrorManager;

public class RuntimeErrorCatcher
implements RuntimeErrorConsumer {
    private List<RuntimeErrorConsumer> storedConsumers = new ArrayList<RuntimeErrorConsumer>();
    private final List<RuntimeError> cachedErrors = new ArrayList<RuntimeError>();
    private static final int ERROR_LIMIT = 1000;

    private RuntimeErrorManager getManager() {
        return Skript.getRuntimeErrorManager();
    }

    @Override
    @Nullable
    public RuntimeErrorFilter getFilter() {
        return RuntimeErrorFilter.NO_FILTER;
    }

    public RuntimeErrorCatcher start() {
        this.storedConsumers = this.getManager().removeAllConsumers();
        this.getManager().addConsumer(this);
        return this;
    }

    public void stop() {
        if (!this.getManager().removeConsumer(this)) {
            SkriptLogger.LOGGER.severe("[Skript] A 'RuntimeErrorCatcher' was stopped incorrectly.");
            return;
        }
        this.getManager().addConsumers((RuntimeErrorConsumer[])this.storedConsumers.toArray(RuntimeErrorConsumer[]::new));
        for (RuntimeError runtimeError : this.cachedErrors) {
            this.storedConsumers.forEach(consumer -> consumer.printError(runtimeError));
        }
    }

    public @UnmodifiableView List<RuntimeError> getCachedErrors() {
        return Collections.unmodifiableList(this.cachedErrors);
    }

    public RuntimeErrorCatcher clearCachedErrors() {
        this.cachedErrors.clear();
        return this;
    }

    @Override
    public void printError(RuntimeError error) {
        if (this.cachedErrors.size() < 1000) {
            this.cachedErrors.add(error);
        }
    }

    @Override
    public void printFrameOutput(Frame.FrameOutput output, Level level) {
    }
}

