/**
 *   This file is part of Skript.
 *
 *  Skript is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Skript is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Skript.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Copyright Peter Güttinger, SkriptLang team and contributors
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Events;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.EventValueExpression;
import ch.njol.skript.lang.ExpressionType;
import org.bukkit.entity.Egg;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name("The Egg")
@Description("The egg thrown in a Player Egg Throw event.")
@Examples("spawn an egg at the egg")
@Events("Egg Throw")
@Since("2.7")
public class ExprEgg extends EventValueExpression<Egg> {

	static {
		Skript.registerExpression(ExprEgg.class, Egg.class, ExpressionType.SIMPLE, "[the] [thrown] egg");
	}

	public ExprEgg() {
		super(Egg.class, true);
	}

	@Override
	public String toString(@Nullable Event event, boolean debug) {
		return "the egg";
	}

}
