/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.localization.Language;
import ch.njol.skript.util.Utils;
import ch.njol.skript.util.Version;
import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.eclipse.jdt.annotation.Nullable;

public final class SkriptAddon {
    public final JavaPlugin plugin;
    public final Version version;
    private final String name;
    private @Nullable String languageFileDirectory = null;
    private @Nullable File file;

    SkriptAddon(JavaPlugin p) {
        Version v;
        this.plugin = p;
        this.name = "" + p.getName();
        try {
            v = new Version("" + p.getDescription().getVersion());
        }
        catch (IllegalArgumentException e) {
            Matcher m = Pattern.compile("(\\d+)(?:\\.(\\d+)(?:\\.(\\d+))?)?").matcher(p.getDescription().getVersion());
            if (!m.find()) {
                throw new IllegalArgumentException("The version of the plugin " + p.getName() + " does not contain any numbers: " + p.getDescription().getVersion());
            }
            v = new Version(Utils.parseInt("" + m.group(1)), m.group(2) == null ? 0 : Utils.parseInt("" + m.group(2)), m.group(3) == null ? 0 : Utils.parseInt("" + m.group(3)));
            Skript.warning("The plugin " + p.getName() + " uses a non-standard version syntax: '" + p.getDescription().getVersion() + "'. Skript will use " + v + " instead.");
        }
        this.version = v;
    }

    public final String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public SkriptAddon loadClasses(String basePackage, String ... subPackages) throws IOException {
        Utils.getClasses((Plugin)this.plugin, basePackage, subPackages);
        return this;
    }

    public SkriptAddon setLanguageFileDirectory(String directory) {
        if (this.languageFileDirectory != null) {
            throw new IllegalStateException();
        }
        directory = "" + directory.replace('\\', '/');
        if (directory.endsWith("/")) {
            directory = "" + directory.substring(0, directory.length() - 1);
        }
        this.languageFileDirectory = directory;
        Language.loadDefault(this);
        return this;
    }

    public @Nullable String getLanguageFileDirectory() {
        return this.languageFileDirectory;
    }

    public @Nullable File getFile() {
        if (this.file == null) {
            this.file = Utils.getFile((Plugin)this.plugin);
        }
        return this.file;
    }
}

