/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.SkriptUpdater;
import ch.njol.skript.config.Config;
import ch.njol.skript.config.EnumParser;
import ch.njol.skript.config.Option;
import ch.njol.skript.config.OptionSection;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.hooks.Hook;
import ch.njol.skript.hooks.VaultHook;
import ch.njol.skript.hooks.regions.GriefPreventionHook;
import ch.njol.skript.hooks.regions.PreciousStonesHook;
import ch.njol.skript.hooks.regions.ResidenceHook;
import ch.njol.skript.hooks.regions.WorldGuardHook;
import ch.njol.skript.lang.function.Function;
import ch.njol.skript.localization.Language;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.log.Verbosity;
import ch.njol.skript.timings.SkriptTimings;
import ch.njol.skript.update.ReleaseChannel;
import ch.njol.skript.util.FileUtils;
import ch.njol.skript.util.Timespan;
import ch.njol.skript.util.Version;
import ch.njol.skript.util.chat.ChatMessages;
import ch.njol.skript.util.chat.LinkParseMode;
import ch.njol.skript.variables.Variables;
import co.aikar.timings.Timings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.bukkit.event.EventPriority;
import org.eclipse.jdt.annotation.Nullable;

public class SkriptConfig {
    static @Nullable Config mainConfig;
    static Collection<Config> configs;
    static final Option<String> version;
    public static final Option<String> language;
    static final Option<Boolean> checkForNewVersion;
    static final Option<Timespan> updateCheckInterval;
    static final Option<Integer> updaterDownloadTries;
    static final Option<String> releaseChannel;
    public static final Option<Boolean> enableEffectCommands;
    public static final Option<String> effectCommandToken;
    public static final Option<Boolean> allowOpsToUseEffectCommands;
    @Deprecated
    public static final Option<Boolean> logPlayerCommands;
    public static final Option<Boolean> logEffectCommands;
    public static final OptionSection databases;
    public static final Option<Boolean> usePlayerUUIDsInVariableNames;
    public static final Option<Boolean> enablePlayerVariableFix;
    private static final DateFormat shortDateFormat;
    private static final Option<DateFormat> dateFormat;
    static final Option<Verbosity> verbosity;
    public static final Option<EventPriority> defaultEventPriority;
    public static final Option<Integer> numberAccuracy;
    public static final Option<Integer> maxTargetBlockDistance;
    public static final Option<Boolean> caseSensitive;
    public static final Option<Boolean> allowFunctionsBeforeDefs;
    public static final Option<Boolean> disableObjectCannotBeSavedWarnings;
    public static final Option<Boolean> disableMissingAndOrWarnings;
    public static final Option<Boolean> disableVariableStartingWithExpressionWarnings;
    @Deprecated
    public static final Option<Boolean> enableScriptCaching;
    public static final Option<Boolean> keepConfigsLoaded;
    public static final Option<Boolean> addonSafetyChecks;
    public static final Option<Boolean> apiSoftExceptions;
    public static final Option<Boolean> enableTimings;
    public static final Option<String> parseLinks;
    public static final Option<Boolean> caseInsensitiveVariables;
    public static final Option<Boolean> colorResetCodes;
    public static final Option<String> scriptLoaderThreadSize;
    public static final Option<Boolean> allowUnsafePlatforms;
    public static final Option<Boolean> keepLastUsageDates;
    public static final Option<Boolean> loadDefaultAliases;
    public static final Option<Boolean> executeFunctionsWithMissingParams;
    public static final Option<Boolean> disableHookVault;
    public static final Option<Boolean> disableHookGriefPrevention;
    public static final Option<Boolean> disableHookPreciousStones;
    public static final Option<Boolean> disableHookResidence;
    public static final Option<Boolean> disableHookWorldGuard;
    public static final Option<Pattern> playerNameRegexPattern;
    public static final Option<Timespan> longParseTimeWarningThreshold;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatDate(long timestamp) {
        DateFormat f;
        DateFormat dateFormat = f = SkriptConfig.dateFormat.value();
        synchronized (dateFormat) {
            return "" + f.format(timestamp);
        }
    }

    private static void userDisableHooks(Class<? extends Hook<?>> hookClass, boolean value) {
        if (Skript.isFinishedLoadingHooks()) {
            Skript.error("Hooks cannot be disabled once the server has started. Please restart the server to disable the hooks.");
            return;
        }
        if (value) {
            Skript.disableHookRegistration(hookClass);
        }
    }

    public static @Nullable Config getConfig() {
        return mainConfig;
    }

    static boolean load() {
        try {
            Config mc;
            File oldConfigFile = new File(Skript.getInstance().getDataFolder(), "config.cfg");
            File configFile = new File(Skript.getInstance().getDataFolder(), "config.sk");
            if (oldConfigFile.exists()) {
                if (!configFile.exists()) {
                    oldConfigFile.renameTo(configFile);
                    Skript.info("[1.3] Renamed your 'config.cfg' to 'config.sk' to match the new format");
                } else {
                    Skript.error("Found both a new and an old config, ignoring the old one");
                }
            }
            if (!configFile.exists()) {
                Skript.error("Config file 'config.sk' does not exist!");
                return false;
            }
            if (!configFile.canRead()) {
                Skript.error("Config file 'config.sk' cannot be read!");
                return false;
            }
            try {
                mc = new Config(configFile, false, false, ":");
            }
            catch (IOException e) {
                Skript.error("Could not load the main config: " + e.getLocalizedMessage());
                return false;
            }
            mainConfig = mc;
            String configVersion = mc.get(SkriptConfig.version.key);
            if (configVersion == null || Skript.getVersion().compareTo(new Version(configVersion)) != 0) {
                try {
                    InputStream in = Skript.getInstance().getResource("config.sk");
                    if (in == null) {
                        Skript.error("Your config is outdated, but Skript couldn't find the newest config in its jar.");
                        return false;
                    }
                    Config newConfig = new Config(in, "Skript.jar/config.sk", false, false, ":");
                    in.close();
                    boolean forceUpdate = false;
                    if (mc.getMainNode().get("database") != null) {
                        forceUpdate = true;
                        try {
                            SectionNode oldDB = (SectionNode)mc.getMainNode().get("database");
                            assert (oldDB != null);
                            SectionNode newDBs = (SectionNode)newConfig.getMainNode().get(SkriptConfig.databases.key);
                            assert (newDBs != null);
                            SectionNode newDB = (SectionNode)newDBs.get("database 1");
                            assert (newDB != null);
                            newDB.setValues(oldDB, new String[0]);
                            String file = newDB.getValue("file");
                            assert (file != null);
                            if (!file.endsWith(".db")) {
                                newDB.set("file", file + ".db");
                            }
                            SectionNode def = (SectionNode)newDBs.get("default");
                            assert (def != null);
                            def.set("backup interval", "" + mc.get("variables backup interval"));
                        }
                        catch (Exception e) {
                            Skript.error("An error occurred while trying to update the config's database section.");
                            Skript.error("You'll have to update the config yourself:");
                            Skript.error("Open the new config.sk as well as the created backup, and move the 'database' section from the backup to the start of the 'databases' section");
                            Skript.error("of the new config (i.e. the line 'databases:' should be directly above 'database:'), and add a tab in front of every line that you just copied.");
                            return false;
                        }
                    }
                    if (newConfig.setValues(mc, SkriptConfig.version.key, SkriptConfig.databases.key) || forceUpdate) {
                        File bu = FileUtils.backup(configFile);
                        newConfig.getMainNode().set(SkriptConfig.version.key, Skript.getVersion().toString());
                        if (mc.getMainNode().get(SkriptConfig.databases.key) != null) {
                            newConfig.getMainNode().set(SkriptConfig.databases.key, mc.getMainNode().get(SkriptConfig.databases.key));
                        }
                        mc = mainConfig = newConfig;
                        mc.save(configFile);
                        Skript.info("Your configuration has been updated to the latest version. A backup of your old config file has been created as " + bu.getName());
                    } else {
                        mc.getMainNode().set(SkriptConfig.version.key, Skript.getVersion().toString());
                        mc.save(configFile);
                    }
                }
                catch (IOException e) {
                    Skript.error("Could not load the new config from the jar file: " + e.getLocalizedMessage());
                }
            }
            mc.load(SkriptConfig.class);
        }
        catch (RuntimeException e) {
            Skript.exception((Throwable)e, "An error occurred while loading the config");
            return false;
        }
        return true;
    }

    static {
        configs = new ArrayList<Config>();
        version = new Option<String>("version", Skript.getVersion().toString()).optional(true);
        language = new Option<String>("language", "english").optional(true).setter(s -> {
            if (!Language.load(s)) {
                Skript.error("No language file found for '" + s + "'!");
            }
        });
        checkForNewVersion = new Option<Boolean>("check for new version", false).setter(t -> {
            SkriptUpdater updater = Skript.getInstance().getUpdater();
            if (updater != null) {
                updater.setEnabled((boolean)t);
            }
        });
        updateCheckInterval = new Option<Timespan>("update check interval", new Timespan(43200000L)).setter(t -> {
            SkriptUpdater updater = Skript.getInstance().getUpdater();
            if (updater != null) {
                updater.setCheckFrequency(t.getTicks_i());
            }
        });
        updaterDownloadTries = new Option<Integer>("updater download tries", 7).optional(true);
        releaseChannel = new Option<String>("release channel", "none").setter(t -> {
            ReleaseChannel channel;
            switch (t) {
                case "alpha": {
                    channel = new ReleaseChannel(name -> true, (String)t);
                    break;
                }
                case "beta": {
                    channel = new ReleaseChannel(name -> !name.contains("alpha"), (String)t);
                    break;
                }
                case "stable": {
                    channel = new ReleaseChannel(name -> !name.contains("alpha") && !name.contains("beta"), (String)t);
                    break;
                }
                case "none": {
                    channel = new ReleaseChannel(name -> false, (String)t);
                    break;
                }
                default: {
                    channel = new ReleaseChannel(name -> false, (String)t);
                    Skript.error("Unknown release channel '" + t + "'.");
                }
            }
            SkriptUpdater updater = Skript.getInstance().getUpdater();
            if (updater != null) {
                if (updater.getCurrentRelease().flavor.contains("spigot") && !t.equals("stable")) {
                    Skript.error("Only stable Skript versions are uploaded to Spigot resources.");
                }
                updater.setReleaseChannel(channel);
            }
        });
        enableEffectCommands = new Option<Boolean>("enable effect commands", false);
        effectCommandToken = new Option<String>("effect command token", "!");
        allowOpsToUseEffectCommands = new Option<Boolean>("allow ops to use effect commands", false);
        logPlayerCommands = new Option<Boolean>("log player commands", false).optional(true);
        logEffectCommands = new Option<Boolean>("log effect commands", false);
        databases = new OptionSection("databases");
        usePlayerUUIDsInVariableNames = new Option<Boolean>("use player UUIDs in variable names", false);
        enablePlayerVariableFix = new Option<Boolean>("player variable fix", true);
        shortDateFormat = DateFormat.getDateTimeInstance(3, 3);
        dateFormat = new Option<DateFormat>("date format", shortDateFormat, s -> {
            try {
                if (s.equalsIgnoreCase("default")) {
                    return null;
                }
                return new SimpleDateFormat((String)s);
            }
            catch (IllegalArgumentException e) {
                Skript.error("'" + s + "' is not a valid date format. Please refer to https://docs.oracle.com/javase/8/docs/api/java/text/SimpleDateFormat.html for instructions on the format.");
                return null;
            }
        });
        verbosity = new Option<Verbosity>("verbosity", Verbosity.NORMAL, new EnumParser<Verbosity>(Verbosity.class, "verbosity")).setter(SkriptLogger::setVerbosity);
        defaultEventPriority = new Option<EventPriority>("plugin priority", EventPriority.NORMAL, s -> {
            try {
                return EventPriority.valueOf((String)s.toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException e) {
                Skript.error("The plugin priority has to be one of lowest, low, normal, high, or highest.");
                return null;
            }
        });
        numberAccuracy = new Option<Integer>("number accuracy", 2);
        maxTargetBlockDistance = new Option<Integer>("maximum target block distance", 100);
        caseSensitive = new Option<Boolean>("case sensitive", false);
        allowFunctionsBeforeDefs = new Option<Boolean>("allow function calls before definations", false).optional(true);
        disableObjectCannotBeSavedWarnings = new Option<Boolean>("disable variable will not be saved warnings", false);
        disableMissingAndOrWarnings = new Option<Boolean>("disable variable missing and/or warnings", false);
        disableVariableStartingWithExpressionWarnings = new Option<Boolean>("disable starting a variable's name with an expression warnings", false);
        enableScriptCaching = new Option<Boolean>("enable script caching", false).optional(true);
        keepConfigsLoaded = new Option<Boolean>("keep configs loaded", false).optional(true);
        addonSafetyChecks = new Option<Boolean>("addon safety checks", false).optional(true);
        apiSoftExceptions = new Option<Boolean>("soft api exceptions", false);
        enableTimings = new Option<Boolean>("enable timings", false).setter(t -> {
            if (!Skript.classExists("co.aikar.timings.Timings")) {
                if (t.booleanValue()) {
                    Skript.warning("Timings cannot be enabled! You are running Bukkit/Spigot, but Paper is required.");
                }
                SkriptTimings.setEnabled(false);
                return;
            }
            if (Timings.class.isAnnotationPresent(Deprecated.class)) {
                if (t.booleanValue()) {
                    Skript.warning("Timings cannot be enabled! Paper no longer supports Timings as of 1.19.4.");
                }
                SkriptTimings.setEnabled(false);
                return;
            }
            if (t.booleanValue()) {
                Skript.info("Timings support enabled!");
            }
            SkriptTimings.setEnabled(t);
        });
        parseLinks = new Option<String>("parse links in chat messages", "disabled").setter(t -> {
            try {
                switch (t) {
                    case "false": 
                    case "disabled": {
                        ChatMessages.linkParseMode = LinkParseMode.DISABLED;
                        break;
                    }
                    case "true": 
                    case "lenient": {
                        ChatMessages.linkParseMode = LinkParseMode.LENIENT;
                        break;
                    }
                    case "strict": {
                        ChatMessages.linkParseMode = LinkParseMode.STRICT;
                        break;
                    }
                    default: {
                        ChatMessages.linkParseMode = LinkParseMode.DISABLED;
                        Skript.warning("Unknown link parse mode: " + t + ", please use disabled, strict or lenient");
                        break;
                    }
                }
            }
            catch (Error error) {
                // empty catch block
            }
        });
        caseInsensitiveVariables = new Option<Boolean>("case-insensitive variables", true).setter(t -> {
            Variables.caseInsensitiveVariables = t;
        }).optional(true);
        colorResetCodes = new Option<Boolean>("color codes reset formatting", true).setter(t -> {
            try {
                ChatMessages.colorResetCodes = t;
            }
            catch (Error error) {
                // empty catch block
            }
        });
        scriptLoaderThreadSize = new Option<String>("script loader thread size", "0").setter(s -> {
            int asyncLoaderSize;
            if (s.equalsIgnoreCase("processor count")) {
                asyncLoaderSize = Runtime.getRuntime().availableProcessors();
            } else {
                try {
                    asyncLoaderSize = Integer.parseInt(s);
                }
                catch (NumberFormatException e) {
                    Skript.error("Invalid option: " + s);
                    return;
                }
            }
            ScriptLoader.setAsyncLoaderSize(asyncLoaderSize);
        }).optional(true);
        allowUnsafePlatforms = new Option<Boolean>("allow unsafe platforms", false).optional(true);
        keepLastUsageDates = new Option<Boolean>("keep command last usage dates", false).optional(true);
        loadDefaultAliases = new Option<Boolean>("load default aliases", true).optional(true);
        executeFunctionsWithMissingParams = new Option<Boolean>("execute functions with missing parameters", true).optional(true).setter(t -> {
            Function.executeWithNulls = t;
        });
        disableHookVault = new Option<Boolean>("disable hooks.vault", false).optional(true).setter(value -> SkriptConfig.userDisableHooks(VaultHook.class, value));
        disableHookGriefPrevention = new Option<Boolean>("disable hooks.regions.grief prevention", false).optional(true).setter(value -> SkriptConfig.userDisableHooks(GriefPreventionHook.class, value));
        disableHookPreciousStones = new Option<Boolean>("disable hooks.regions.precious stones", false).optional(true).setter(value -> SkriptConfig.userDisableHooks(PreciousStonesHook.class, value));
        disableHookResidence = new Option<Boolean>("disable hooks.regions.residence", false).optional(true).setter(value -> SkriptConfig.userDisableHooks(ResidenceHook.class, value));
        disableHookWorldGuard = new Option<Boolean>("disable hooks.regions.worldguard", false).optional(true).setter(value -> SkriptConfig.userDisableHooks(WorldGuardHook.class, value));
        playerNameRegexPattern = new Option<Pattern>("player name regex pattern", Pattern.compile("[a-zA-Z0-9_]{1,16}"), s -> {
            try {
                return Pattern.compile(s);
            }
            catch (PatternSyntaxException e) {
                Skript.error("Invalid player name regex pattern: " + e.getMessage());
                return null;
            }
        }).optional(true);
        longParseTimeWarningThreshold = new Option<Timespan>("long parse time warning threshold", new Timespan(0L));
    }
}

