/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.bukkitutil;

import ch.njol.util.Math2;
import org.bukkit.attribute.Attributable;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;
import org.bukkit.event.entity.EntityDamageEvent;

public class HealthUtils {
    public static double getHealth(Damageable e) {
        if (e.isDead()) {
            return 0.0;
        }
        return e.getHealth() / 2.0;
    }

    public static void setHealth(Damageable e, double health) {
        e.setHealth(Math2.fit(0.0, health, HealthUtils.getMaxHealth(e)) * 2.0);
    }

    public static double getMaxHealth(Damageable e) {
        AttributeInstance attributeInstance = ((Attributable)e).getAttribute(Attribute.GENERIC_MAX_HEALTH);
        assert (attributeInstance != null);
        return attributeInstance.getValue() / 2.0;
    }

    public static void setMaxHealth(Damageable e, double health) {
        AttributeInstance attributeInstance = ((Attributable)e).getAttribute(Attribute.GENERIC_MAX_HEALTH);
        assert (attributeInstance != null);
        attributeInstance.setBaseValue(health * 2.0);
    }

    public static void damage(Damageable e, double d) {
        if (d < 0.0) {
            HealthUtils.heal(e, -d);
            return;
        }
        e.damage(d * 2.0);
    }

    public static void heal(Damageable e, double h) {
        if (h < 0.0) {
            HealthUtils.damage(e, -h);
            return;
        }
        HealthUtils.setHealth(e, HealthUtils.getHealth(e) + h);
    }

    public static double getDamage(EntityDamageEvent e) {
        return e.getDamage() / 2.0;
    }

    public static double getFinalDamage(EntityDamageEvent e) {
        return e.getFinalDamage() / 2.0;
    }

    public static void setDamage(EntityDamageEvent e, double damage) {
        e.setDamage(damage * 2.0);
    }

    public static void setDamageCause(Damageable e, EntityDamageEvent.DamageCause cause) {
        e.setLastDamageCause(new EntityDamageEvent((Entity)e, cause, 0.0));
    }
}

