/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.bukkitutil;

import ch.njol.skript.Skript;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.eclipse.jdt.annotation.Nullable;

public class ItemUtils {
    private static final boolean IS_AIR_EXISTS = Skript.methodExists(Material.class, "isAir", new Class[0]);

    public static int getDamage(ItemStack stack) {
        ItemMeta meta = stack.getItemMeta();
        if (meta instanceof Damageable) {
            return ((Damageable)meta).getDamage();
        }
        return 0;
    }

    public static void setDamage(ItemStack stack, int damage) {
        ItemMeta meta = stack.getItemMeta();
        if (meta instanceof Damageable) {
            ((Damageable)meta).setDamage(damage);
            stack.setItemMeta(meta);
        }
    }

    public static @Nullable Material asBlock(Material type) {
        if (type.isBlock()) {
            return type;
        }
        return null;
    }

    public static Material asItem(Material type) {
        return type;
    }

    public static boolean itemStacksEqual(@Nullable ItemStack is1, @Nullable ItemStack is2) {
        if (is1 == null || is2 == null) {
            return is1 == is2;
        }
        return is1.getType() == is2.getType() && ItemUtils.getDamage(is1) == ItemUtils.getDamage(is2) && is1.getItemMeta().equals(is2.getItemMeta());
    }

    public static boolean isAir(Material type) {
        if (IS_AIR_EXISTS) {
            return type.isAir();
        }
        return type == Material.AIR || type == Material.CAVE_AIR || type == Material.VOID_AIR;
    }
}

