/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.command;

import ch.njol.skript.Skript;
import ch.njol.skript.localization.ArgsMessage;
import ch.njol.skript.localization.Message;
import ch.njol.skript.util.SkriptColor;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.eclipse.jdt.annotation.Nullable;

public class CommandHelp {
    private static final String DEFAULTENTRY = "description";
    private static final ArgsMessage m_invalid_argument = new ArgsMessage("commands.invalid argument");
    private static final Message m_usage = new Message("skript command.usage");
    private String command;
    private @Nullable Message description = null;
    private final String argsColor;
    private @Nullable String langNode = null;
    private final LinkedHashMap<String, Object> arguments = new LinkedHashMap();
    private @Nullable Message wildcardArg = null;

    public CommandHelp(String command, SkriptColor argsColor, String langNode) {
        this.command = command;
        this.argsColor = "" + argsColor.getFormattedChat();
        this.langNode = langNode;
        this.description = new Message(langNode + "." + DEFAULTENTRY);
    }

    public CommandHelp(String command, SkriptColor argsColor) {
        this.command = command;
        this.argsColor = "" + argsColor.getFormattedChat();
    }

    public CommandHelp add(String argument) {
        if (this.langNode == null) {
            if (argument.startsWith("<") && argument.endsWith(">")) {
                String carg = ChatColor.GRAY + "<" + this.argsColor + argument.substring(1, argument.length() - 1) + ChatColor.GRAY + ">";
                this.arguments.put(carg, argument);
            } else {
                this.arguments.put(argument, null);
            }
        } else if (argument.startsWith("<") && argument.endsWith(">")) {
            String carg = ChatColor.GRAY + "<" + this.argsColor + argument.substring(1, argument.length() - 1) + ChatColor.GRAY + ">";
            this.wildcardArg = new Message(this.langNode + "." + argument);
            this.arguments.put(carg, this.wildcardArg);
        } else {
            this.arguments.put(argument, new Message(this.langNode + "." + argument));
        }
        return this;
    }

    public CommandHelp add(CommandHelp help) {
        this.arguments.put(help.command, help);
        help.onAdd(this);
        return this;
    }

    protected void onAdd(CommandHelp parent) {
        this.langNode = parent.langNode + "." + this.command;
        this.description = new Message(this.langNode + "." + DEFAULTENTRY);
        this.command = parent.command + " " + parent.argsColor + this.command;
        for (Map.Entry<String, Object> e : this.arguments.entrySet()) {
            if (e.getValue() instanceof CommandHelp) {
                ((CommandHelp)e.getValue()).onAdd(this);
                continue;
            }
            if (e.getValue() != null) {
                this.wildcardArg = new Message(this.langNode + "." + e.getValue());
                e.setValue(this.wildcardArg);
                continue;
            }
            e.setValue(new Message(this.langNode + "." + e.getKey()));
        }
    }

    public boolean test(CommandSender sender, String[] args) {
        return this.test(sender, args, 0);
    }

    private boolean test(CommandSender sender, String[] args, int index) {
        if (index >= args.length) {
            this.showHelp(sender);
            return false;
        }
        Object help = this.arguments.get(args[index].toLowerCase(Locale.ENGLISH));
        if (help == null && this.wildcardArg == null) {
            this.showHelp(sender, m_invalid_argument.toString(this.argsColor + args[index]));
            return false;
        }
        if (help instanceof CommandHelp) {
            return ((CommandHelp)help).test(sender, args, index + 1);
        }
        return true;
    }

    public void showHelp(CommandSender sender) {
        this.showHelp(sender, m_usage.toString());
    }

    private void showHelp(CommandSender sender, String pre) {
        Skript.message(sender, pre + " " + this.command + " " + this.argsColor + "...");
        for (Map.Entry<String, Object> e : this.arguments.entrySet()) {
            Skript.message(sender, "  " + this.argsColor + e.getKey() + " " + ChatColor.GRAY + "-" + ChatColor.RESET + " " + e.getValue());
        }
    }

    public String toString() {
        return "" + this.description;
    }
}

