/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.AABB;
import ch.njol.util.Kleenean;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Is Within")
@Description(value={"Whether a location is within something else. The \"something\" can be a block, an entity, a chunk, a world, or a cuboid formed by two other locations.", "Note that using the <a href='conditions.html#CondCompare'>is between</a> condition will refer to a straight line between locations, while this condition will refer to the cuboid between locations."})
@Examples(value={"if player's location is within {_loc1} and {_loc2}:", "\tsend \"You are in a PvP zone!\" to player", "", "if player is in world(\"world\"):", "\tsend \"You are in the overworld!\" to player", "", "if attacker's location is inside of victim:", "\tcancel event", "\tsend \"Back up!\" to attacker and victim"})
@Since(value="2.7")
@RequiredPlugins(value={"MC 1.17+ (within block)"})
public class CondIsWithin
extends Condition {
    private Expression<Location> locsToCheck;
    private Expression<Location> loc1;
    private Expression<Location> loc2;
    private Expression<?> area;
    private boolean withinLocations;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.setNegated(matchedPattern % 2 == 1);
        this.locsToCheck = exprs[0];
        if (matchedPattern <= 1) {
            this.withinLocations = true;
            this.loc1 = exprs[1];
            this.loc2 = exprs[2];
        } else {
            this.withinLocations = false;
            this.area = exprs[1];
        }
        return true;
    }

    @Override
    public boolean check(Event event) {
        if (this.withinLocations) {
            Location one = this.loc1.getSingle(event);
            Location two = this.loc2.getSingle(event);
            if (one == null || two == null || one.getWorld() != two.getWorld()) {
                return false;
            }
            AABB box = new AABB(one, two);
            return this.locsToCheck.check(event, box::contains, this.isNegated());
        }
        Object area = this.area.getSingle(event);
        if (area == null) {
            return false;
        }
        if (area instanceof Entity) {
            BoundingBox box = ((Entity)area).getBoundingBox();
            return this.locsToCheck.check(event, loc -> box.contains(loc.toVector()), this.isNegated());
        }
        if (area instanceof Block) {
            for (BoundingBox box : ((Block)area).getCollisionShape().getBoundingBoxes()) {
                Vector blockVector;
                if (this.locsToCheck.check(event, arg_0 -> CondIsWithin.lambda$check$1(box, blockVector = ((Block)area).getLocation().toVector(), arg_0), this.isNegated())) continue;
                return false;
            }
            return true;
        }
        if (area instanceof Chunk) {
            return this.locsToCheck.check(event, loc -> loc.getChunk().equals(area), this.isNegated());
        }
        if (area instanceof World) {
            return this.locsToCheck.check(event, loc -> loc.getWorld().equals(area), this.isNegated());
        }
        return false;
    }

    @Override
    public String toString(@Nullable Event event, boolean debug) {
        String str = this.locsToCheck.toString(event, debug) + " is within ";
        str = this.withinLocations ? str + this.loc1.toString(event, debug) + " and " + this.loc2.toString(event, debug) : str + this.area.toString(event, debug);
        return str;
    }

    private static /* synthetic */ boolean lambda$check$1(BoundingBox box, Vector blockVector, Location loc) {
        return box.contains(loc.toVector().subtract(blockVector));
    }

    static {
        String validTypes = "entity/chunk/world";
        if (Skript.methodExists(Block.class, "getCollisionShape", new Class[0])) {
            validTypes = validTypes + "/block";
        }
        Skript.registerCondition(CondIsWithin.class, "%locations% (is|are) within %location% and %location%", "%locations% (isn't|is not|aren't|are not) within %location% and %location%", "%locations% (is|are) (within|in[side [of]]) %" + validTypes + "%", "%locations% (isn't|is not|aren't|are not) (within|in[side [of]]) %" + validTypes + "%");
    }
}

