/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.Aliases;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.bukkitutil.PlayerUtils;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.Material;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.ChestedHorse;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Llama;
import org.bukkit.entity.Pig;
import org.bukkit.entity.Player;
import org.bukkit.entity.Steerable;
import org.bukkit.event.Event;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.LlamaInventory;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Equip")
@Description(value={"Equips or unequips an entity with some given armor. This will replace any armor that the entity is wearing."})
@Examples(value={"equip player with diamond helmet", "equip player with all diamond armor", "unequip diamond chestplate from player", "unequip all armor from player", "unequip player's armor"})
@Since(value="1.0, 2.7 (multiple entities, unequip)")
public class EffEquip
extends Effect {
    private Expression<LivingEntity> entities;
    private @Nullable Expression<ItemType> itemTypes;
    private boolean equip = true;
    private static final boolean SUPPORTS_STEERABLE;
    private static final ItemType CHESTPLATE;
    private static final ItemType LEGGINGS;
    private static final ItemType BOOTS;
    private static final ItemType HORSE_ARMOR;
    private static final ItemType SADDLE;
    private static final ItemType CHEST;
    private static final ItemType CARPET;
    private static final ItemType[] ALL_EQUIPMENT;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        if (matchedPattern == 0 || matchedPattern == 1) {
            this.entities = exprs[0];
            this.itemTypes = exprs[1];
        } else if (matchedPattern == 2) {
            this.itemTypes = exprs[0];
            this.entities = exprs[1];
            this.equip = false;
        } else if (matchedPattern == 3) {
            this.entities = exprs[0];
            this.equip = false;
        }
        return true;
    }

    @Override
    protected void execute(Event event) {
        ItemType[] itemTypes;
        boolean unequipHelmet = false;
        if (this.itemTypes != null) {
            itemTypes = this.itemTypes.getArray(event);
        } else {
            itemTypes = ALL_EQUIPMENT;
            unequipHelmet = true;
        }
        block0: for (LivingEntity entity : this.entities.getArray(event)) {
            LlamaInventory inv;
            if (SUPPORTS_STEERABLE && entity instanceof Steerable) {
                for (ItemType itemType : itemTypes) {
                    if (!SADDLE.isOfType(itemType.getMaterial())) continue;
                    ((Steerable)entity).setSaddle(this.equip);
                }
                continue;
            }
            if (entity instanceof Pig) {
                for (ItemType itemType : itemTypes) {
                    if (!itemType.isOfType(Material.SADDLE)) continue;
                    ((Pig)entity).setSaddle(this.equip);
                    continue block0;
                }
                continue;
            }
            if (entity instanceof Llama) {
                inv = ((Llama)entity).getInventory();
                for (ItemType itemType : itemTypes) {
                    for (ItemStack item : itemType.getAll()) {
                        if (CARPET.isOfType(item)) {
                            inv.setDecor((ItemStack)(this.equip ? item : null));
                            continue;
                        }
                        if (!CHEST.isOfType(item)) continue;
                        ((Llama)entity).setCarryingChest(this.equip);
                    }
                }
                continue;
            }
            if (entity instanceof AbstractHorse) {
                inv = ((AbstractHorse)entity).getInventory();
                for (ItemType itemType : itemTypes) {
                    for (ItemStack item : itemType.getAll()) {
                        if (SADDLE.isOfType(item)) {
                            inv.setItem(0, (ItemStack)(this.equip ? item : null));
                            continue;
                        }
                        if (HORSE_ARMOR.isOfType(item)) {
                            inv.setItem(1, (ItemStack)(this.equip ? item : null));
                            continue;
                        }
                        if (!CHEST.isOfType(item) || !(entity instanceof ChestedHorse)) continue;
                        ((ChestedHorse)entity).setCarryingChest(this.equip);
                    }
                }
                continue;
            }
            EntityEquipment equipment = entity.getEquipment();
            if (equipment == null) continue;
            for (ItemType itemType : itemTypes) {
                for (ItemStack item : itemType.getAll()) {
                    if (CHESTPLATE.isOfType(item)) {
                        equipment.setChestplate((ItemStack)(this.equip ? item : null));
                        continue;
                    }
                    if (LEGGINGS.isOfType(item)) {
                        equipment.setLeggings((ItemStack)(this.equip ? item : null));
                        continue;
                    }
                    if (BOOTS.isOfType(item)) {
                        equipment.setBoots((ItemStack)(this.equip ? item : null));
                        continue;
                    }
                    equipment.setHelmet((ItemStack)(this.equip ? item : null));
                }
                if (!unequipHelmet) continue;
                equipment.setHelmet(null);
            }
            if (!(entity instanceof Player)) continue;
            PlayerUtils.updateInventory((Player)entity);
        }
    }

    @Override
    public String toString(@Nullable Event event, boolean debug) {
        if (this.equip) {
            assert (this.itemTypes != null);
            return "equip " + this.entities.toString(event, debug) + " with " + this.itemTypes.toString(event, debug);
        }
        if (this.itemTypes != null) {
            return "unequip " + this.itemTypes.toString(event, debug) + " from " + this.entities.toString(event, debug);
        }
        return "unequip " + this.entities.toString(event, debug) + "'s equipment";
    }

    static {
        Skript.registerEffect(EffEquip.class, "equip [%livingentities%] with %itemtypes%", "make %livingentities% wear %itemtypes%", "unequip %itemtypes% [from %livingentities%]", "unequip %livingentities%'[s] (armor|equipment)");
        SUPPORTS_STEERABLE = Skript.classExists("org.bukkit.entity.Steerable");
        CHESTPLATE = Aliases.javaItemType("chestplate");
        LEGGINGS = Aliases.javaItemType("leggings");
        BOOTS = Aliases.javaItemType("boots");
        HORSE_ARMOR = Aliases.javaItemType("horse armor");
        SADDLE = Aliases.javaItemType("saddle");
        CHEST = Aliases.javaItemType("chest");
        CARPET = Aliases.javaItemType("carpet");
        ALL_EQUIPMENT = new ItemType[]{CHESTPLATE, LEGGINGS, BOOTS, HORSE_ARMOR, SADDLE, CHEST, CARPET};
    }
}

