/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.SkriptCommand;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.FileUtils;
import ch.njol.util.Kleenean;
import ch.njol.util.OpenCloseable;
import java.io.File;
import java.io.IOException;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;
import org.skriptlang.skript.lang.script.Script;

@Name(value="Enable/Disable/Reload Script File")
@Description(value={"Enables, disables, or reloads a script file."})
@Examples(value={"reload script \"test\"", "enable script file \"testing\"", "unload script file \"script.sk\""})
@Since(value="2.4")
public class EffScriptFile
extends Effect {
    private static final int ENABLE = 1;
    private static final int RELOAD = 2;
    private static final int DISABLE = 3;
    private int mark;
    private Expression<String> fileName;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.mark = parseResult.mark;
        this.fileName = exprs[0];
        return true;
    }

    @Override
    protected void execute(Event e) {
        String name = this.fileName.getSingle(e);
        if (name == null) {
            return;
        }
        File scriptFile = SkriptCommand.getScriptFromName(name);
        if (scriptFile == null) {
            return;
        }
        switch (this.mark) {
            case 1: {
                if (ScriptLoader.getLoadedScriptsFilter().accept(scriptFile)) {
                    return;
                }
                try {
                    scriptFile = FileUtils.move(scriptFile, new File(scriptFile.getParentFile(), scriptFile.getName().substring(ScriptLoader.DISABLED_SCRIPT_PREFIX_LENGTH)), false);
                }
                catch (IOException ex) {
                    Skript.exception((Throwable)ex, "Error while enabling script file: " + name);
                    return;
                }
                ScriptLoader.loadScripts(scriptFile, OpenCloseable.EMPTY);
                break;
            }
            case 2: {
                if (ScriptLoader.getDisabledScriptsFilter().accept(scriptFile)) {
                    return;
                }
                Script script = ScriptLoader.getScript(scriptFile);
                if (script != null) {
                    ScriptLoader.unloadScript(script);
                }
                ScriptLoader.loadScripts(scriptFile, OpenCloseable.EMPTY);
                break;
            }
            case 3: {
                if (ScriptLoader.getDisabledScriptsFilter().accept(scriptFile)) {
                    return;
                }
                Script script = ScriptLoader.getScript(scriptFile);
                if (script != null) {
                    ScriptLoader.unloadScript(script);
                }
                try {
                    FileUtils.move(scriptFile, new File(scriptFile.getParentFile(), "-" + scriptFile.getName()), false);
                    break;
                }
                catch (IOException ex) {
                    Skript.exception((Throwable)ex, "Error while disabling script file: " + name);
                    return;
                }
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return (this.mark == 1 ? "enable" : (this.mark == 2 ? "disable" : (this.mark == 3 ? "unload" : ""))) + " script file " + this.fileName.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffScriptFile.class, "(1:(enable|load)|2:reload|3:(disable|unload)) s(c|k)ript [file] %string%");
    }
}

