/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.util.Locale;
import java.util.regex.Pattern;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Stop Sound")
@Description(value={"Stops specific or all sounds from playing to a group of players. Both Minecraft sound names and <a href=\"https://hub.spigotmc.org/javadocs/spigot/org/bukkit/Sound.html\">Spigot sound names</a> are supported. Resource pack sounds are supported too. The sound category is 'master' by default. A sound can't be stopped from a different category. ", "", "Please note that sound names can get changed in any Minecraft or Spigot version, or even removed from Minecraft itself."})
@Examples(value={"stop sound \"block.chest.open\" for the player", "stop playing sounds \"ambient.underwater.loop\" and \"ambient.underwater.loop.additions\" to the player", "stop all sounds for all players", "stop sound in the record category"})
@Since(value="2.4, 2.7 (stop all sounds)")
@RequiredPlugins(value={"MC 1.17.1 (stop all sounds)"})
public class EffStopSound
extends Effect {
    private static final boolean STOP_ALL_SUPPORTED = Skript.methodExists(Player.class, "stopAllSounds", new Class[0]);
    private static final Pattern KEY_PATTERN = Pattern.compile("([a-z0-9._-]+:)?[a-z0-9/._-]+");
    private @Nullable Expression<SoundCategory> category;
    private @Nullable Expression<String> sounds;
    private Expression<Player> players;
    private boolean allSounds;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.allSounds = parseResult.hasTag("all");
        this.sounds = exprs[0];
        this.category = exprs[1];
        this.players = exprs[2];
        return true;
    }

    @Override
    protected void execute(Event event) {
        block10: {
            Player[] targets;
            SoundCategory category;
            block9: {
                category = this.category == null ? null : this.category.getOptionalSingle(event).orElse(this.allSounds ? null : SoundCategory.MASTER);
                targets = this.players.getArray(event);
                if (!this.allSounds) break block9;
                if (category == null) {
                    for (Player player : targets) {
                        player.stopAllSounds();
                    }
                } else {
                    for (Player player : targets) {
                        player.stopSound(category);
                    }
                }
                break block10;
            }
            if (this.sounds == null) break block10;
            for (String sound : this.sounds.getArray(event)) {
                try {
                    Sound soundEnum = Sound.valueOf((String)sound.toUpperCase(Locale.ENGLISH));
                    Player[] playerArray = targets;
                    int n = playerArray.length;
                    for (int i = 0; i < n; ++i) {
                        Player player = playerArray[i];
                        player.stopSound(soundEnum, category);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    sound = sound.toLowerCase(Locale.ENGLISH);
                    if (!KEY_PATTERN.matcher(sound).matches()) continue;
                    for (Player player : targets) {
                        player.stopSound(sound, category);
                    }
                }
            }
        }
    }

    @Override
    public String toString(@Nullable Event event, boolean debug) {
        return (this.allSounds ? "stop all sounds " : "stop sound " + this.sounds.toString(event, debug)) + (this.category != null ? " in " + this.category.toString(event, debug) : "") + " from playing to " + this.players.toString(event, debug);
    }

    static {
        String stopPattern = STOP_ALL_SUPPORTED ? "(all:all sound[s]|sound[s] %-strings%)" : "sound[s] %strings%";
        Skript.registerEffect(EffStopSound.class, "stop " + stopPattern + " [(in [the]|from) %-soundcategory%] [(from playing to|for) %players%]", "stop playing sound[s] %strings% [(in [the]|from) %-soundcategory%] [(to|for) %players%]");
    }
}

