/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.bukkitutil.ItemUtils;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.slot.Slot;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Damage Value/Durability")
@Description(value={"The damage value/durability of an item."})
@Examples(value={"set damage value of player's tool to 10", "reset the durability of {_item}", "set durability of player's held item to 0"})
@Since(value="1.2, 2.7 (durability reversed)")
public class ExprDurability
extends SimplePropertyExpression<Object, Long> {
    private boolean durability;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.durability = parseResult.hasTag("durability");
        return super.init(exprs, matchedPattern, isDelayed, parseResult);
    }

    @Override
    public @Nullable Long convert(Object object) {
        ItemStack itemStack = null;
        if (object instanceof Slot) {
            itemStack = ((Slot)object).getItem();
        } else if (object instanceof ItemType) {
            itemStack = ((ItemType)object).getRandom();
        }
        if (itemStack == null) {
            return null;
        }
        long damage = ItemUtils.getDamage(itemStack);
        return this.durability ? (long)itemStack.getType().getMaxDurability() - damage : damage;
    }

    @Override
    public @Nullable Class<?>[] acceptChange(Changer.ChangeMode mode) {
        switch (mode) {
            case SET: 
            case ADD: 
            case REMOVE: 
            case DELETE: 
            case RESET: {
                return CollectionUtils.array(Number.class);
            }
        }
        return null;
    }

    @Override
    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        F[] objects;
        int i = delta == null ? 0 : ((Number)delta[0]).intValue();
        for (Object object : objects = this.getExpr().getArray(event)) {
            ItemStack itemStack = null;
            if (object instanceof ItemType) {
                itemStack = ((ItemType)object).getRandom();
            } else if (object instanceof Slot) {
                itemStack = ((Slot)object).getItem();
            }
            if (itemStack == null) {
                return;
            }
            int changeValue = ItemUtils.getDamage(itemStack);
            if (this.durability) {
                changeValue = itemStack.getType().getMaxDurability() - changeValue;
            }
            switch (mode) {
                case REMOVE: {
                    i = -i;
                }
                case ADD: {
                    changeValue += i;
                    break;
                }
                case SET: {
                    changeValue = i;
                    break;
                }
                case DELETE: 
                case RESET: {
                    changeValue = 0;
                    break;
                }
                case REMOVE_ALL: {
                    assert (false);
                    break;
                }
            }
            if (this.durability && mode != Changer.ChangeMode.RESET && mode != Changer.ChangeMode.DELETE) {
                changeValue = itemStack.getType().getMaxDurability() - changeValue;
            }
            if (object instanceof ItemType) {
                ItemUtils.setDamage(itemStack, changeValue);
                ((ItemType)object).setTo(new ItemType(itemStack));
                continue;
            }
            ItemUtils.setDamage(itemStack, changeValue);
            ((Slot)object).setItem(itemStack);
        }
    }

    @Override
    public Class<? extends Long> getReturnType() {
        return Long.class;
    }

    @Override
    public String getPropertyName() {
        return this.durability ? "durability" : "damage";
    }

    static {
        ExprDurability.register(ExprDurability.class, Long.class, "(damage[s] [value[s]]|durability:durabilit(y|ies))", "itemtypes/slots");
    }
}

