/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Explosive;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Explosive Yield")
@Description(value={"The yield of an explosive (creeper, primed tnt, fireball, etc.). This is how big of an explosion is caused by the entity.", "Read <a href='https://minecraft.gamepedia.com/Explosion'>this wiki page</a> for more information"})
@Examples(value={"on spawn of a creeper:", "\tset the explosive yield of the event-entity to 10"})
@RequiredPlugins(value={"Minecraft 1.12 or newer for creepers"})
@Since(value="2.5")
public class ExprExplosiveYield
extends SimplePropertyExpression<Entity, Number> {
    private static final boolean CREEPER_USABLE;

    @Override
    public Number convert(Entity e) {
        if (e instanceof Explosive) {
            return Float.valueOf(((Explosive)e).getYield());
        }
        if (CREEPER_USABLE && e instanceof Creeper) {
            return ((Creeper)e).getExplosionRadius();
        }
        return 0;
    }

    @Override
    public @Nullable Class<?>[] acceptChange(Changer.ChangeMode mode) {
        switch (mode) {
            case SET: 
            case ADD: 
            case REMOVE: 
            case DELETE: {
                return CollectionUtils.array(Number.class);
            }
        }
        return null;
    }

    @Override
    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Integer change = delta != null ? (Number)((Number)delta[0]) : (Number)0;
        block13: for (Entity entity : (Entity[])this.getExpr().getArray(event)) {
            if (entity instanceof Explosive) {
                Explosive e = (Explosive)entity;
                float f = ((Number)change).floatValue();
                if (f < 0.0f) {
                    return;
                }
                switch (mode) {
                    case SET: {
                        e.setYield(f);
                        break;
                    }
                    case ADD: {
                        float add = e.getYield() + f;
                        if (add < 0.0f) {
                            return;
                        }
                        e.setYield(add);
                        break;
                    }
                    case REMOVE: {
                        float subtract = e.getYield() - f;
                        if (subtract < 0.0f) {
                            return;
                        }
                        e.setYield(subtract);
                        break;
                    }
                    case DELETE: {
                        e.setYield(0.0f);
                        break;
                    }
                    default: {
                        assert (false);
                        continue block13;
                    }
                }
                continue;
            }
            if (!CREEPER_USABLE || !(entity instanceof Creeper)) continue;
            Creeper c = (Creeper)entity;
            int i = change;
            if (i < 0) {
                return;
            }
            switch (mode) {
                case SET: {
                    c.setExplosionRadius(i);
                    continue block13;
                }
                case ADD: {
                    int add = c.getExplosionRadius() + i;
                    if (add < 0) {
                        return;
                    }
                    c.setExplosionRadius(add);
                    continue block13;
                }
                case REMOVE: {
                    int subtract = c.getExplosionRadius() - i;
                    if (subtract < 0) {
                        return;
                    }
                    c.setExplosionRadius(subtract);
                    continue block13;
                }
                case DELETE: {
                    c.setExplosionRadius(0);
                    continue block13;
                }
                case REMOVE_ALL: 
                case RESET: {
                    assert (false);
                    continue block13;
                }
            }
        }
    }

    @Override
    public Class<Number> getReturnType() {
        return Number.class;
    }

    @Override
    protected String getPropertyName() {
        return "explosive yield";
    }

    static {
        ExprExplosiveYield.register(ExprExplosiveYield.class, Number.class, "explosive (yield|radius|size)", "entities");
        CREEPER_USABLE = Skript.methodExists(Creeper.class, "getExplosionRadius", new Class[0]);
    }
}

