/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Events;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.effects.Delay;
import ch.njol.skript.expressions.ExprBurnCookTime;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.Getter;
import ch.njol.skript.util.slot.InventorySlot;
import ch.njol.skript.util.slot.Slot;
import ch.njol.util.Kleenean;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Furnace;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.FurnaceBurnEvent;
import org.bukkit.event.inventory.FurnaceSmeltEvent;
import org.bukkit.inventory.FurnaceInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Furnace Slot")
@Description(value={"A slot of a furnace, i.e. either the ore, fuel or result slot.", "Remember to use '<a href='#ExprBlock'>block</a>' and not 'furnace', as 'furnace' is not an existing expression."})
@Examples(value={"set the fuel slot of the clicked block to a lava bucket", "set the block's ore slot to 64 iron ore", "give the result of the block to the player", "clear the result slot of the block"})
@Since(value="1.0")
@Events(value={"smelt", "fuel burn"})
public class ExprFurnaceSlot
extends PropertyExpression<Block, Slot> {
    private static final int ORE = 0;
    private static final int FUEL = 1;
    private static final int RESULT = 2;
    private static final String[] slotNames = new String[]{"ore", "fuel", "result"};
    int slot;
    boolean isEvent;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.isEvent = matchedPattern == 0;
        this.slot = parseResult.mark;
        if (this.isEvent && this.slot == 2 && !this.getParser().isCurrentEvent((Class<? extends Event>)FurnaceSmeltEvent.class)) {
            Skript.error("Cannot use 'result slot' outside a fuel smelt event.");
            return false;
        }
        if (this.isEvent && this.slot == 1 && !this.getParser().isCurrentEvent((Class<? extends Event>)FurnaceBurnEvent.class)) {
            Skript.error("Cannot use 'fuel slot' outside a fuel burn event.");
            return false;
        }
        if (!this.isEvent) {
            this.setExpr(exprs[0]);
        }
        return true;
    }

    protected Slot[] get(final Event e, Block[] source) {
        return this.get(source, new Getter<Slot, Block>(){

            @Override
            public @Nullable Slot get(Block b) {
                if (!ExprBurnCookTime.anyFurnace.isOfType(b)) {
                    return null;
                }
                if (ExprFurnaceSlot.this.isEvent && ExprFurnaceSlot.this.getTime() > -1 && !Delay.isDelayed(e)) {
                    FurnaceInventory invi = ((Furnace)b.getState()).getInventory();
                    return new FurnaceEventSlot(e, invi);
                }
                FurnaceInventory invi = ((Furnace)b.getState()).getInventory();
                return new InventorySlot((Inventory)invi, ExprFurnaceSlot.this.slot);
            }
        });
    }

    @Override
    public Class<Slot> getReturnType() {
        return Slot.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        if (e == null) {
            return "the " + (this.getTime() == -1 ? "past " : (this.getTime() == 1 ? "future " : "")) + slotNames[this.slot] + " slot of " + this.getExpr().toString(e, debug);
        }
        return Classes.getDebugMessage(this.getSingle(e));
    }

    @Override
    public boolean setTime(int time) {
        return super.setTime(time, this.getExpr(), FurnaceSmeltEvent.class, FurnaceBurnEvent.class);
    }

    static {
        Skript.registerExpression(ExprFurnaceSlot.class, Slot.class, ExpressionType.PROPERTY, "(1\u00a6fuel|2\u00a6result) [slot]", "(0\u00a6ore|1\u00a6fuel|2\u00a6result)[s] [slot[s]] of %blocks%", "%blocks%'[s] (0\u00a6ore|1\u00a6fuel|2\u00a6result)[s] [slot[s]]");
    }

    private final class FurnaceEventSlot
    extends InventorySlot {
        private final Event e;

        public FurnaceEventSlot(Event e, FurnaceInventory invi) {
            super((Inventory)invi, ExprFurnaceSlot.this.slot);
            this.e = e;
        }

        @Override
        public @Nullable ItemStack getItem() {
            switch (ExprFurnaceSlot.this.slot) {
                case 2: {
                    if (this.e instanceof FurnaceSmeltEvent) {
                        return ExprFurnaceSlot.this.getTime() > -1 ? ((FurnaceSmeltEvent)this.e).getResult().clone() : super.getItem();
                    }
                    return super.getItem();
                }
                case 1: {
                    if (this.e instanceof FurnaceBurnEvent) {
                        return ExprFurnaceSlot.this.getTime() > -1 ? ((FurnaceBurnEvent)this.e).getFuel().clone() : super.getItem();
                    }
                    return this.pastItem();
                }
                case 0: {
                    if (this.e instanceof FurnaceSmeltEvent) {
                        return this.pastItem();
                    }
                    return super.getItem();
                }
            }
            return null;
        }

        @Override
        public void setItem(@Nullable ItemStack item) {
            if (ExprFurnaceSlot.this.getTime() > -1) {
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Skript.getInstance(), () -> FurnaceEventSlot.super.setItem(item));
            } else if (this.e instanceof FurnaceSmeltEvent && ExprFurnaceSlot.this.slot == 2) {
                if (item != null) {
                    ((FurnaceSmeltEvent)this.e).setResult(item);
                } else {
                    ((FurnaceSmeltEvent)this.e).setResult(new ItemStack(Material.AIR));
                }
            } else {
                super.setItem(item);
            }
        }

        private @Nullable ItemStack pastItem() {
            if (ExprFurnaceSlot.this.getTime() < 1) {
                return super.getItem();
            }
            ItemStack item = super.getItem();
            if (item == null) {
                return null;
            }
            item.setAmount(item.getAmount() - 1);
            return item.getAmount() == 0 ? new ItemStack(Material.AIR, 1) : item;
        }
    }
}

