/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.Aliases;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.slot.Slot;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.GameRule;
import org.bukkit.Nameable;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Name / Display Name / Tab List Name")
@Description(value={"Represents the Minecraft account, display or tab list name of a player, or the custom name of an item, entity, block, inventory, gamerule or world.", "", "<ul>", "\t<li><strong>Players</strong>", "\t\t<ul>", "\t\t\t<li><strong>Name:</strong> The Minecraft account name of the player. Can't be changed, but 'display name' can be changed.</li>", "\t\t\t<li><strong>Display Name:</strong> The name of the player that is displayed in messages. This name can be changed freely and can include color codes, and is shared among all plugins (e.g. chat plugins will use the display name).</li>", "\t\t</ul>", "\t</li>", "\t<li><strong>Entities</strong>", "\t\t<ul>", "\t\t\t<li><strong>Name:</strong> The custom name of the entity. Can be changed. But for living entities, the players will have to target the entity to see its name tag. For non-living entities, the name will not be visible at all. To prevent this, use 'display name'.</li>", "\t\t\t<li><strong>Display Name:</strong> The custom name of the entity. Can be changed, which will also enable <em>custom name visibility</em> of the entity so name tag of the entity will be visible always.</li>", "\t\t</ul>", "\t</li>", "\t<li><strong>Items</strong>", "\t\t<ul>", "\t\t\t<li><strong>Name and Display Name:</strong> The <em>custom</em> name of the item (not the Minecraft locale name). Can be changed.</li>", "\t\t</ul>", "\t</li>", "\t<li><strong>Inventories</strong>", "\t\t<ul>", "\t\t\t<li><strong>Name and Display Name:</strong> The name/title of the inventory. Changing name of an inventory means opening the same inventory with the same contents but with a different name to its current viewers.</li>", "\t\t</ul>", "\t</li>", "\t<li><strong>Gamerules (1.13+)</strong>", "\t\t<ul>", "\t\t\t<li><strong>Name:</strong> The name of the gamerule. Cannot be changed.</li>", "\t\t</ul>", "\t</li>", "\t<li><strong>Worlds</strong>", "\t\t<ul>", "\t\t\t<li><strong>Name:</strong> The name of the world. Cannot be changed.</li>", "\t\t</ul>", "\t</li>", "</ul>"})
@Examples(value={"on join:", "\tplayer has permission \"name.red\"", "\tset the player's display name to \"&lt;red&gt;[admin] &lt;gold&gt;%name of player%\"", "\tset the player's tab list name to \"&lt;green&gt;%player's name%\"", "set the name of the player's tool to \"Legendary Sword of Awesomeness\""})
@Since(value="before 2.1, 2.2-dev20 (inventory name), 2.4 (non-living entity support, changeable inventory name), 2.7 (worlds)")
public class ExprName
extends SimplePropertyExpression<Object, String> {
    static final @Nullable MethodHandle TITLE_METHOD;
    static final boolean HAS_GAMERULES;
    private int mark;
    private static final ItemType AIR;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.mark = parseResult.mark;
        this.setExpr(exprs[0]);
        if (this.mark != 1 && World.class.isAssignableFrom(this.getExpr().getReturnType())) {
            Skript.error("Can't use 'display name' with worlds. Use 'name' instead.");
            return false;
        }
        return true;
    }

    @Override
    public @Nullable String convert(Object o) {
        if (o instanceof OfflinePlayer && ((OfflinePlayer)o).isOnline()) {
            o = ((OfflinePlayer)o).getPlayer();
        }
        if (o instanceof Player) {
            switch (this.mark) {
                case 1: {
                    return ((Player)o).getName();
                }
                case 2: {
                    return ((Player)o).getDisplayName();
                }
                case 3: {
                    return ((Player)o).getPlayerListName();
                }
            }
        } else {
            if (o instanceof OfflinePlayer) {
                return this.mark == 1 ? ((OfflinePlayer)o).getName() : null;
            }
            if (o instanceof Entity) {
                return ((Entity)o).getCustomName();
            }
            if (o instanceof Block) {
                BlockState state = ((Block)o).getState();
                if (state instanceof Nameable) {
                    return ((Nameable)state).getCustomName();
                }
            } else {
                if (o instanceof ItemType) {
                    ItemMeta m = ((ItemType)o).getItemMeta();
                    return m.hasDisplayName() ? m.getDisplayName() : null;
                }
                if (o instanceof Inventory) {
                    if (TITLE_METHOD != null) {
                        try {
                            return TITLE_METHOD.invoke(o);
                        }
                        catch (Throwable ex) {
                            Skript.exception(ex, new String[0]);
                            return null;
                        }
                    }
                    if (!((Inventory)o).getViewers().isEmpty()) {
                        return ((HumanEntity)((Inventory)o).getViewers().get(0)).getOpenInventory().getTitle();
                    }
                    return null;
                }
                if (o instanceof Slot) {
                    ItemStack is = ((Slot)o).getItem();
                    if (is != null && is.hasItemMeta()) {
                        ItemMeta m = is.getItemMeta();
                        return m.hasDisplayName() ? m.getDisplayName() : null;
                    }
                } else {
                    if (o instanceof World) {
                        return ((World)o).getName();
                    }
                    if (HAS_GAMERULES && o instanceof GameRule) {
                        return ((GameRule)o).getName();
                    }
                }
            }
        }
        return null;
    }

    @Override
    public @Nullable Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.RESET) {
            if (this.mark == 1) {
                if (Player.class.isAssignableFrom(this.getExpr().getReturnType())) {
                    Skript.error("Can't change the Minecraft name of a player. Change the 'display name' or 'tab list name' instead.");
                    return null;
                }
                if (World.class.isAssignableFrom(this.getExpr().getReturnType())) {
                    return null;
                }
            }
            return CollectionUtils.array(String.class);
        }
        return null;
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        String name = delta != null ? (String)delta[0] : null;
        for (Object o : this.getExpr().getArray(e)) {
            Slot s;
            ItemStack is;
            if (o instanceof Player) {
                switch (this.mark) {
                    case 2: {
                        ((Player)o).setDisplayName(name != null ? name + ChatColor.RESET : ((Player)o).getName());
                        break;
                    }
                    case 3: {
                        ((Player)o).setPlayerListName(name);
                    }
                }
                continue;
            }
            if (o instanceof Entity) {
                ((Entity)o).setCustomName(name);
                if (this.mark == 2 || mode == Changer.ChangeMode.RESET) {
                    ((Entity)o).setCustomNameVisible(name != null);
                }
                if (!(o instanceof LivingEntity)) continue;
                ((LivingEntity)o).setRemoveWhenFarAway(name == null);
                continue;
            }
            if (o instanceof Block) {
                BlockState state = ((Block)o).getState();
                if (!(state instanceof Nameable)) continue;
                ((Nameable)state).setCustomName(name);
                state.update();
                continue;
            }
            if (o instanceof ItemType) {
                ItemType i = (ItemType)o;
                ItemMeta m = i.getItemMeta();
                m.setDisplayName(name);
                i.setItemMeta(m);
                continue;
            }
            if (o instanceof Inventory) {
                Inventory inv = (Inventory)o;
                if (inv.getViewers().isEmpty()) {
                    return;
                }
                ArrayList viewers = new ArrayList(inv.getViewers());
                InventoryType type = inv.getType();
                if (!type.isCreatable()) {
                    return;
                }
                if (name == null) {
                    name = type.getDefaultTitle();
                }
                Inventory copy = type == InventoryType.CHEST ? Bukkit.createInventory((InventoryHolder)inv.getHolder(), (int)inv.getSize(), (String)name) : Bukkit.createInventory((InventoryHolder)inv.getHolder(), (InventoryType)type, (String)name);
                copy.setContents(inv.getContents());
                viewers.forEach(viewer -> viewer.openInventory(copy));
                continue;
            }
            if (!(o instanceof Slot) || (is = (s = (Slot)o).getItem()) == null || AIR.isOfType(is)) continue;
            ItemMeta m = is.hasItemMeta() ? is.getItemMeta() : Bukkit.getItemFactory().getItemMeta(is.getType());
            m.setDisplayName(name);
            is.setItemMeta(m);
            s.setItem(is);
        }
    }

    @Override
    public Class<String> getReturnType() {
        return String.class;
    }

    @Override
    protected String getPropertyName() {
        switch (this.mark) {
            case 1: {
                return "name";
            }
            case 2: {
                return "display name";
            }
            case 3: {
                return "tablist name";
            }
        }
        return "name";
    }

    static {
        HAS_GAMERULES = Skript.classExists("org.bukkit.GameRule");
        ExprName.register(ExprName.class, String.class, "(1\u00a6name[s]|2\u00a6(display|nick|chat|custom)[ ]name[s])", "offlineplayers/entities/blocks/itemtypes/inventories/slots/worlds" + (HAS_GAMERULES ? "/gamerules" : ""));
        ExprName.register(ExprName.class, String.class, "(3\u00a6(player|tab)[ ]list name[s])", "players");
        MethodHandle _METHOD = null;
        try {
            _METHOD = MethodHandles.lookup().findVirtual(Inventory.class, "getTitle", MethodType.methodType(String.class));
        }
        catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
            // empty catch block
        }
        TITLE_METHOD = _METHOD;
        AIR = Aliases.javaItemType("air");
    }
}

