/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.effects.Delay;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.util.Vector;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Target")
@Description(value={"For players this is the entity at the crosshair.", "For mobs and experience orbs this is the entity they are attacking/following (if any)."})
@Examples(value={"on entity target:", "\tif entity's target is a player:", "\t\tsend \"You're being followed by an %entity%!\" to target of entity", "", "reset target of entity # Makes the entity target-less", "delete targeted entity of player # for players it will delete the target", "delete target of last spawned zombie # for entities it will make them target-less"})
@Since(value="1.4.2, 2.7 (Reset)")
public class ExprTarget
extends PropertyExpression<LivingEntity, Entity> {
    private @Nullable EntityData<?> type;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.type = exprs[matchedPattern] == null ? null : (EntityData)exprs[matchedPattern].getSingle(null);
        this.setExpr(exprs[1 - matchedPattern]);
        return true;
    }

    protected Entity[] get(Event event, LivingEntity[] source) {
        return this.get(source, entity -> {
            if (event instanceof EntityTargetEvent && entity.equals(((EntityTargetEvent)event).getEntity()) && !Delay.isDelayed(event)) {
                Entity target = ((EntityTargetEvent)event).getTarget();
                if (target == null || this.type != null && !this.type.isInstance(target)) {
                    return null;
                }
                return target;
            }
            return ExprTarget.getTarget(entity, this.type);
        });
    }

    @Override
    public @Nullable Class<?>[] acceptChange(Changer.ChangeMode mode) {
        switch (mode) {
            case SET: 
            case RESET: 
            case DELETE: {
                return CollectionUtils.array(LivingEntity.class);
            }
        }
        return super.acceptChange(mode);
    }

    @Override
    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.RESET || mode == Changer.ChangeMode.DELETE) {
            LivingEntity target;
            LivingEntity livingEntity = target = delta == null ? null : (LivingEntity)delta[0];
            if (event instanceof EntityTargetEvent) {
                EntityTargetEvent targetEvent = (EntityTargetEvent)event;
                for (LivingEntity entity : (LivingEntity[])this.getExpr().getArray(event)) {
                    if (!entity.equals(targetEvent.getEntity())) continue;
                    targetEvent.setTarget((Entity)target);
                }
            } else {
                for (LivingEntity entity : (LivingEntity[])this.getExpr().getArray(event)) {
                    Object playerTarget;
                    if (entity instanceof Mob) {
                        ((Mob)entity).setTarget(target);
                        continue;
                    }
                    if (!(entity instanceof Player) || mode != Changer.ChangeMode.DELETE || (playerTarget = ExprTarget.getTarget(entity, this.type)) == null || playerTarget instanceof OfflinePlayer) continue;
                    playerTarget.remove();
                }
            }
            return;
        }
        super.change(event, delta, mode);
    }

    @Override
    public boolean setTime(int time) {
        if (time != -1) {
            return super.setTime(time, EntityTargetEvent.class, this.getExpr());
        }
        return super.setTime(time);
    }

    @Override
    public Class<? extends Entity> getReturnType() {
        return this.type != null ? this.type.getType() : Entity.class;
    }

    @Override
    public String toString(@Nullable Event event, boolean debug) {
        return "target" + (this.type == null ? "" : "ed " + this.type) + (this.getExpr().isDefault() ? "" : " of " + this.getExpr().toString(event, debug));
    }

    public static <T extends Entity> @Nullable T getTarget(LivingEntity entity, @Nullable EntityData<T> type) {
        if (entity instanceof Mob) {
            return (T)(((Mob)entity).getTarget() == null || type != null && !type.isInstance((Entity)((Mob)entity).getTarget()) ? null : ((Mob)entity).getTarget());
        }
        Vector direction = entity.getLocation().getDirection().normalize();
        Vector eye = entity.getEyeLocation().toVector();
        double cos45 = Math.cos(0.7853981633974483);
        double targetDistanceSquared = 0.0;
        double radiusSquared = 1.0;
        Entity target = null;
        for (Entity other : type == null ? entity.getWorld().getEntities() : entity.getWorld().getEntitiesByClass(type.getType())) {
            if (other == null || other == entity || type != null && !type.isInstance(other) || target != null && !(targetDistanceSquared > other.getLocation().distanceSquared(entity.getLocation()))) continue;
            Vector t = other.getLocation().add(0.0, 1.0, 0.0).toVector().subtract(eye);
            if (!(direction.clone().crossProduct(t).lengthSquared() < radiusSquared) || !(t.normalize().dot(direction) >= cos45)) continue;
            target = other;
            targetDistanceSquared = target.getLocation().distanceSquared(entity.getLocation());
        }
        return (T)target;
    }

    static {
        Skript.registerExpression(ExprTarget.class, Entity.class, ExpressionType.PROPERTY, "[the] target[[ed] %-*entitydata%] [of %livingentities%]", "%livingentities%'[s] target[[ed] %-*entitydata%]");
    }
}

