/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.Patterns;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Vectors - Arithmetic")
@Description(value={"Arithmetic expressions for vectors."})
@Examples(value={"set {_v} to vector 1, 2, 3 // vector 5, 5, 5", "set {_v} to {_v} ++ {_v}", "set {_v} to {_v} -- {_v}", "set {_v} to {_v} ** {_v}", "set {_v} to {_v} // {_v}"})
@Since(value="2.2-desecond8")
public class ExprVectorArithmetic
extends SimpleExpression<Vector> {
    private static final Patterns<Operator> patterns = new Patterns(new Object[][]{{"%vector%[ ]++[ ]%vector%", Operator.PLUS}, {"%vector%[ ]--[ ]%vector%", Operator.MINUS}, {"%vector%[ ]**[ ]%vector%", Operator.MULT}, {"%vector%[ ]//[ ]%vector%", Operator.DIV}});
    private Expression<Vector> first;
    private Expression<Vector> second;
    private Operator operator;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.first = exprs[0];
        this.second = exprs[1];
        this.operator = patterns.getInfo(matchedPattern);
        return true;
    }

    protected Vector[] get(Event event) {
        Vector first = this.first.getOptionalSingle(event).orElse(new Vector());
        Vector second = this.second.getOptionalSingle(event).orElse(new Vector());
        return CollectionUtils.array(this.operator.calculate(first, second));
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public Class<? extends Vector> getReturnType() {
        return Vector.class;
    }

    @Override
    public String toString(@Nullable Event event, boolean debug) {
        return this.first.toString(event, debug) + " " + (Object)((Object)this.operator) + " " + this.second.toString(event, debug);
    }

    static {
        Skript.registerExpression(ExprVectorArithmetic.class, Vector.class, ExpressionType.SIMPLE, patterns.getPatterns());
    }

    private static enum Operator {
        PLUS("++"){

            @Override
            public Vector calculate(Vector first, Vector second) {
                return first.clone().add(second);
            }
        }
        ,
        MINUS("--"){

            @Override
            public Vector calculate(Vector first, Vector second) {
                return first.clone().subtract(second);
            }
        }
        ,
        MULT("**"){

            @Override
            public Vector calculate(Vector first, Vector second) {
                return first.clone().multiply(second);
            }
        }
        ,
        DIV("//"){

            @Override
            public Vector calculate(Vector first, Vector second) {
                return first.clone().divide(second);
            }
        };

        public final String sign;

        private Operator(String sign) {
            this.sign = sign;
        }

        public abstract Vector calculate(Vector var1, Vector var2);

        public String toString() {
            return this.sign;
        }
    }
}

