/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Vectors - Velocity")
@Description(value={"Gets or changes velocity of an entity."})
@Examples(value={"set player's velocity to {_v}"})
@Since(value="2.2-dev31")
public class ExprVelocity
extends SimplePropertyExpression<Entity, Vector> {
    @Override
    public @Nullable Vector convert(Entity e) {
        return e.getVelocity();
    }

    @Override
    public @Nullable Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.DELETE || mode == Changer.ChangeMode.RESET) {
            return CollectionUtils.array(Vector.class);
        }
        return null;
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        assert (mode == Changer.ChangeMode.DELETE || mode == Changer.ChangeMode.RESET || delta != null);
        block7: for (Entity entity : (Entity[])this.getExpr().getArray(e)) {
            if (entity == null) {
                return;
            }
            switch (mode) {
                case ADD: {
                    entity.setVelocity(entity.getVelocity().add((Vector)delta[0]));
                    continue block7;
                }
                case REMOVE: {
                    entity.setVelocity(entity.getVelocity().subtract((Vector)delta[0]));
                    continue block7;
                }
                case REMOVE_ALL: {
                    continue block7;
                }
                case DELETE: 
                case RESET: {
                    entity.setVelocity(new Vector());
                    continue block7;
                }
                case SET: {
                    entity.setVelocity((Vector)delta[0]);
                }
            }
        }
    }

    @Override
    protected String getPropertyName() {
        return "velocity";
    }

    @Override
    public Class<Vector> getReturnType() {
        return Vector.class;
    }

    static {
        ExprVelocity.register(ExprVelocity.class, Vector.class, "velocit(y|ies)", "entities");
    }
}

