/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Whitelist")
@Description(value={"A server's whitelist.This expression can be used to add/remove players to/from the whitelist, to enable it and disable it (set whitelist to true / set whitelist to false), and to empty it (reset whitelist)"})
@Examples(value={"set whitelist to false", "add all players to whitelist", "reset the whitelist"})
@Since(value="2.5.2")
public class ExprWhitelist
extends SimpleExpression<OfflinePlayer> {
    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        return true;
    }

    protected @Nullable OfflinePlayer[] get(Event e) {
        return Bukkit.getServer().getWhitelistedPlayers().toArray(new OfflinePlayer[0]);
    }

    @Override
    public @Nullable Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE) {
            return CollectionUtils.array(OfflinePlayer[].class);
        }
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.RESET) {
            return CollectionUtils.array(Boolean.class);
        }
        return null;
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        switch (mode) {
            case SET: {
                if (delta == null) break;
                Bukkit.setWhitelist((boolean)((Boolean)delta[0]));
                break;
            }
            case ADD: {
                if (delta == null) break;
                for (Object p : delta) {
                    ((OfflinePlayer)p).setWhitelisted(true);
                }
                break;
            }
            case REMOVE: {
                if (delta == null) break;
                for (Object p : delta) {
                    ((OfflinePlayer)p).setWhitelisted(false);
                }
                break;
            }
            case RESET: {
                for (OfflinePlayer p : Bukkit.getWhitelistedPlayers()) {
                    p.setWhitelisted(false);
                }
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    @Override
    public boolean isSingle() {
        return false;
    }

    @Override
    public Class<? extends OfflinePlayer> getReturnType() {
        return OfflinePlayer.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "whitelist";
    }

    static {
        Skript.registerExpression(ExprWhitelist.class, OfflinePlayer.class, ExpressionType.SIMPLE, "[the] white[ ]list");
    }
}

