/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions.arithmetic;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.arithmetic.ArithmeticChain;
import ch.njol.skript.expressions.arithmetic.ArithmeticGettable;
import ch.njol.skript.expressions.arithmetic.Operator;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.lang.util.SimpleLiteral;
import ch.njol.skript.util.Patterns;
import ch.njol.util.Kleenean;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Arithmetic")
@Description(value={"Arithmetic expressions, e.g. 1 + 2, (health of player - 2) / 3, etc."})
@Examples(value={"set the player's health to 10 - the player's health", "loop (argument + 2) / 5 times:", "\tmessage \"Two useless numbers: %loop-num * 2 - 5%, %2^loop-num - 1%\"", "message \"You have %health of player * 2% half hearts of HP!\""})
@Since(value="1.4.2")
public class ExprArithmetic
extends SimpleExpression<Number> {
    private static final Class<?>[] INTEGER_CLASSES = new Class[]{Long.class, Integer.class, Short.class, Byte.class};
    private static final Patterns<PatternInfo> patterns = new Patterns(new Object[][]{{"\\(%number%\\)[ ]+[ ]\\(%number%\\)", new PatternInfo(Operator.PLUS, true, true)}, {"\\(%number%\\)[ ]+[ ]%number%", new PatternInfo(Operator.PLUS, true, false)}, {"%number%[ ]+[ ]\\(%number%\\)", new PatternInfo(Operator.PLUS, false, true)}, {"%number%[ ]+[ ]%number%", new PatternInfo(Operator.PLUS, false, false)}, {"\\(%number%\\)[ ]-[ ]\\(%number%\\)", new PatternInfo(Operator.MINUS, true, true)}, {"\\(%number%\\)[ ]-[ ]%number%", new PatternInfo(Operator.MINUS, true, false)}, {"%number%[ ]-[ ]\\(%number%\\)", new PatternInfo(Operator.MINUS, false, true)}, {"%number%[ ]-[ ]%number%", new PatternInfo(Operator.MINUS, false, false)}, {"\\(%number%\\)[ ]*[ ]\\(%number%\\)", new PatternInfo(Operator.MULT, true, true)}, {"\\(%number%\\)[ ]*[ ]%number%", new PatternInfo(Operator.MULT, true, false)}, {"%number%[ ]*[ ]\\(%number%\\)", new PatternInfo(Operator.MULT, false, true)}, {"%number%[ ]*[ ]%number%", new PatternInfo(Operator.MULT, false, false)}, {"\\(%number%\\)[ ]/[ ]\\(%number%\\)", new PatternInfo(Operator.DIV, true, true)}, {"\\(%number%\\)[ ]/[ ]%number%", new PatternInfo(Operator.DIV, true, false)}, {"%number%[ ]/[ ]\\(%number%\\)", new PatternInfo(Operator.DIV, false, true)}, {"%number%[ ]/[ ]%number%", new PatternInfo(Operator.DIV, false, false)}, {"\\(%number%\\)[ ]^[ ]\\(%number%\\)", new PatternInfo(Operator.EXP, true, true)}, {"\\(%number%\\)[ ]^[ ]%number%", new PatternInfo(Operator.EXP, true, false)}, {"%number%[ ]^[ ]\\(%number%\\)", new PatternInfo(Operator.EXP, false, true)}, {"%number%[ ]^[ ]%number%", new PatternInfo(Operator.EXP, false, false)}});
    private Expression<? extends Number> first;
    private Expression<? extends Number> second;
    private Operator op;
    private Class<? extends Number> returnType;
    private final List<Object> chain = new ArrayList<Object>();
    private ArithmeticGettable arithmeticGettable;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.first = exprs[0];
        this.second = exprs[1];
        PatternInfo patternInfo = patterns.getInfo(matchedPattern);
        this.op = patternInfo.operator;
        if (this.op == Operator.DIV || this.op == Operator.EXP) {
            this.returnType = Double.class;
        } else {
            Class<? extends Number> firstReturnType = this.first.getReturnType();
            Class<? extends Number> secondReturnType = this.second.getReturnType();
            boolean firstIsInt = false;
            boolean secondIsInt = false;
            for (Class<Number> clazz : INTEGER_CLASSES) {
                firstIsInt |= clazz.isAssignableFrom(firstReturnType);
                secondIsInt |= clazz.isAssignableFrom(secondReturnType);
            }
            Class clazz = this.returnType = firstIsInt && secondIsInt ? Long.class : Double.class;
        }
        if (this.first instanceof ExprArithmetic && !patternInfo.leftGrouped) {
            this.chain.addAll(((ExprArithmetic)this.first).chain);
        } else {
            this.chain.add(this.first);
        }
        this.chain.add((Object)this.op);
        if (this.second instanceof ExprArithmetic && !patternInfo.rightGrouped) {
            this.chain.addAll(((ExprArithmetic)this.second).chain);
        } else {
            this.chain.add(this.second);
        }
        this.arithmeticGettable = ArithmeticChain.parse(this.chain);
        return true;
    }

    protected Number[] get(Event e) {
        Number[] one = (Number[])Array.newInstance(this.returnType, 1);
        one[0] = this.arithmeticGettable.get(e, this.returnType == Long.class);
        return one;
    }

    @Override
    public Class<? extends Number> getReturnType() {
        return this.returnType;
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return this.first.toString(e, debug) + " " + (Object)((Object)this.op) + " " + this.second.toString(e, debug);
    }

    @Override
    public Expression<? extends Number> simplify() {
        if (this.first instanceof Literal && this.second instanceof Literal) {
            return new SimpleLiteral<Number>((Number[])this.getArray(null), Number.class, false);
        }
        return this;
    }

    static {
        Skript.registerExpression(ExprArithmetic.class, Number.class, ExpressionType.PATTERN_MATCHES_EVERYTHING, patterns.getPatterns());
    }

    private static class PatternInfo {
        public final Operator operator;
        public final boolean leftGrouped;
        public final boolean rightGrouped;

        public PatternInfo(Operator operator, boolean leftGrouped, boolean rightGrouped) {
            this.operator = operator;
            this.leftGrouped = leftGrouped;
            this.rightGrouped = rightGrouped;
        }
    }
}

