/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions.base;

import ch.njol.skript.SkriptAPIException;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.DefaultExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.log.ParseLogHandler;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.registrations.EventValues;
import ch.njol.skript.util.Getter;
import ch.njol.skript.util.Utils;
import ch.njol.util.Kleenean;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

public class EventValueExpression<T>
extends SimpleExpression<T>
implements DefaultExpression<T> {
    private final Class<? extends T> c;
    private final Class<?> componentType;
    private @Nullable Changer<? super T> changer;
    private final Map<Class<? extends Event>, Getter<? extends T, ?>> getters = new HashMap();
    private final boolean single;
    private final boolean exact;

    public EventValueExpression(Class<? extends T> c) {
        this(c, null);
    }

    public EventValueExpression(Class<? extends T> c, boolean exact) {
        this(c, null, exact);
    }

    public EventValueExpression(Class<? extends T> c, @Nullable Changer<? super T> changer) {
        this(c, changer, false);
    }

    public EventValueExpression(Class<? extends T> c, @Nullable Changer<? super T> changer, boolean exact) {
        assert (c != null);
        this.c = c;
        this.exact = exact;
        this.changer = changer;
        this.single = !c.isArray();
        this.componentType = this.single ? c : c.getComponentType();
    }

    @Override
    protected @Nullable T[] get(Event event) {
        T value = this.getValue(event);
        if (value == null) {
            return (Object[])Array.newInstance(this.componentType, 0);
        }
        if (this.single) {
            Object[] one = (Object[])Array.newInstance(this.c, 1);
            one[0] = value;
            return one;
        }
        Object[] dataArray = (Object[])value;
        Object[] array = (Object[])Array.newInstance(this.componentType, dataArray.length);
        System.arraycopy(dataArray, 0, array, 0, array.length);
        return array;
    }

    private <E extends Event> @Nullable T getValue(E event) {
        if (this.getters.containsKey(event.getClass())) {
            Getter<? extends T, ?> g = this.getters.get(event.getClass());
            return g == null ? null : (T)g.get(event);
        }
        for (Map.Entry<Class<Event>, Getter<T, ?>> p : this.getters.entrySet()) {
            if (!p.getKey().isAssignableFrom(event.getClass())) continue;
            this.getters.put(event.getClass(), p.getValue());
            return p.getValue() == null ? null : (T)p.getValue().get(event);
        }
        this.getters.put(event.getClass(), null);
        return null;
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        if (exprs.length != 0) {
            throw new SkriptAPIException(this.getClass().getName() + " has expressions in its pattern but does not override init(...)");
        }
        return this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean init() {
        ParseLogHandler log = SkriptLogger.startParseLogHandler();
        try {
            boolean hasValue = false;
            Class<? extends Event>[] events = this.getParser().getCurrentEvents();
            if (events == null) {
                assert (false);
                boolean bl = false;
                return bl;
            }
            for (Class<? extends Event> event : events) {
                if (this.getters.containsKey(event)) {
                    hasValue = this.getters.get(event) != null;
                    continue;
                }
                Getter<Object, Object> getter = this.exact ? EventValues.getExactEventValueGetter(event, this.c, this.getTime()) : EventValues.getEventValueGetter(event, this.c, this.getTime());
                if (getter == null) continue;
                this.getters.put(event, getter);
                hasValue = true;
            }
            if (!hasValue) {
                log.printError("There's no " + Classes.getSuperClassInfo(this.componentType).getName().toString(!this.single) + " in " + Utils.a(this.getParser().getCurrentEventName()) + " event");
                boolean bl = false;
                return bl;
            }
            log.printLog();
            boolean bl = true;
            return bl;
        }
        finally {
            log.stop();
        }
    }

    @Override
    public Class<? extends T> getReturnType() {
        return this.componentType;
    }

    @Override
    public boolean isSingle() {
        return this.single;
    }

    @Override
    public String toString(@Nullable Event event, boolean debug) {
        if (!debug || event == null) {
            return "event-" + Classes.getSuperClassInfo(this.componentType).getName().toString(!this.single);
        }
        return Classes.getDebugMessage(this.getValue(event));
    }

    @Override
    public @Nullable Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (this.changer == null) {
            this.changer = Classes.getSuperClassInfo(this.componentType).getChanger();
        }
        return this.changer == null ? null : this.changer.acceptChange(mode);
    }

    @Override
    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (this.changer == null) {
            throw new SkriptAPIException("The changer cannot be null");
        }
        Changer.ChangerUtils.change(this.changer, this.getArray(event), delta, mode);
    }

    @Override
    public boolean setTime(int time) {
        Class<? extends Event>[] events = this.getParser().getCurrentEvents();
        if (events == null) {
            assert (false);
            return false;
        }
        for (Class<? extends Event> event : events) {
            assert (event != null);
            boolean has = this.exact ? EventValues.doesExactEventValueHaveTimeStates(event, this.c) : EventValues.doesEventValueHaveTimeStates(event, this.c);
            if (!has) continue;
            super.setTime(time);
            this.getters.clear();
            this.init();
            return true;
        }
        return false;
    }

    @Override
    public boolean isDefault() {
        return true;
    }
}

