/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAPIException;
import ch.njol.skript.SkriptConfig;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.command.Argument;
import ch.njol.skript.command.Commands;
import ch.njol.skript.command.ScriptCommand;
import ch.njol.skript.command.ScriptCommandEvent;
import ch.njol.skript.lang.DefaultExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionList;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.LiteralList;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.lang.SyntaxElement;
import ch.njol.skript.lang.SyntaxElementInfo;
import ch.njol.skript.lang.UnparsedLiteral;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.lang.VariableString;
import ch.njol.skript.lang.function.ExprFunctionCall;
import ch.njol.skript.lang.function.FunctionReference;
import ch.njol.skript.lang.parser.ParserInstance;
import ch.njol.skript.lang.util.SimpleLiteral;
import ch.njol.skript.localization.Language;
import ch.njol.skript.localization.Message;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.skript.log.LogEntry;
import ch.njol.skript.log.ParseLogHandler;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.patterns.MalformedPatternException;
import ch.njol.skript.patterns.MatchResult;
import ch.njol.skript.patterns.PatternCompiler;
import ch.njol.skript.patterns.SkriptPattern;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.Utils;
import ch.njol.util.Kleenean;
import ch.njol.util.NonNullPair;
import ch.njol.util.StringUtils;
import ch.njol.util.coll.CollectionUtils;
import com.google.common.primitives.Booleans;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Stream;
import org.bukkit.plugin.java.JavaPlugin;
import org.eclipse.jdt.annotation.Nullable;
import org.skriptlang.skript.lang.script.Script;
import org.skriptlang.skript.lang.script.ScriptWarning;

public class SkriptParser {
    final String expr;
    public static final int PARSE_EXPRESSIONS = 1;
    public static final int PARSE_LITERALS = 2;
    public static final int ALL_FLAGS = 3;
    private final int flags;
    public final ParseContext context;
    public static final String wildcard = "[^\"]*?(?:\"[^\"]*?\"[^\"]*?)*?";
    public static final String stringMatcher = "\"[^\"]*?(?:\"\"[^\"]*)*?\"";
    private static final Pattern varPattern = Pattern.compile("((the )?var(iable)? )?\\{.+\\}", 2);
    public static final Pattern LIST_SPLIT_PATTERN = Pattern.compile("\\s*,?\\s+(and|n?or)\\s+|\\s*,\\s*", 2);
    public static final Pattern OR_PATTERN = Pattern.compile("\\sor\\s", 2);
    private static final String MULTIPLE_AND_OR = "List has multiple 'and' or 'or', will default to 'and'. Use brackets if you want to define multiple lists.";
    private static final String MISSING_AND_OR = "List is missing 'and' or 'or', defaulting to 'and'";
    private boolean suppressMissingAndOrWarnings = SkriptConfig.disableMissingAndOrWarnings.value();
    private static final Pattern functionCallPattern = Pattern.compile("([\\p{IsAlphabetic}][\\p{IsAlphabetic}\\p{IsDigit}_]*)\\((.*)\\)");
    private static final Map<String, SkriptPattern> patterns = new ConcurrentHashMap<String, SkriptPattern>();
    private static final Message m_quotes_error = new Message("skript.quotes error");
    private static final Message m_brackets_error = new Message("skript.brackets error");
    private static final Map<String, ExprInfo> exprInfoCache = new HashMap<String, ExprInfo>();
    @Deprecated
    public static final Pattern listSplitPattern = LIST_SPLIT_PATTERN;

    public SkriptParser(String expr) {
        this(expr, 3);
    }

    public SkriptParser(String expr, int flags) {
        this(expr, flags, ParseContext.DEFAULT);
    }

    public SkriptParser(String expr, int flags, ParseContext context) {
        assert (expr != null);
        assert ((flags & 3) != 0);
        this.expr = "" + expr.trim();
        this.flags = flags;
        this.context = context;
    }

    public SkriptParser(SkriptParser other, String expr) {
        this(expr, other.flags, other.context);
    }

    public static <T> @Nullable Literal<? extends T> parseLiteral(String expr, Class<T> c, ParseContext context) {
        expr = "" + expr.trim();
        if (expr.isEmpty()) {
            return null;
        }
        return new UnparsedLiteral(expr).getConvertedExpression(context, c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends SyntaxElement> @Nullable T parse(String expr, Iterator<? extends SyntaxElementInfo<T>> source, @Nullable String defaultError) {
        expr = "" + expr.trim();
        if (expr.isEmpty()) {
            Skript.error(defaultError);
            return null;
        }
        ParseLogHandler log = SkriptLogger.startParseLogHandler();
        try {
            T e = new SkriptParser(expr).parse(source);
            if (e != null) {
                log.printLog();
                T t = e;
                return t;
            }
            log.printError(defaultError);
            T t = null;
            return t;
        }
        finally {
            log.stop();
        }
    }

    public static <T extends SyntaxElement> @Nullable T parseStatic(String expr, Iterator<? extends SyntaxElementInfo<? extends T>> source, @Nullable String defaultError) {
        return SkriptParser.parseStatic(expr, source, ParseContext.DEFAULT, defaultError);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends SyntaxElement> @Nullable T parseStatic(String expr, Iterator<? extends SyntaxElementInfo<? extends T>> source, ParseContext parseContext, @Nullable String defaultError) {
        if ((expr = expr.trim()).isEmpty()) {
            Skript.error(defaultError);
            return null;
        }
        ParseLogHandler log = SkriptLogger.startParseLogHandler();
        try {
            T e = new SkriptParser(expr, 2, parseContext).parse(source);
            if (e != null) {
                log.printLog();
                T t = e;
                return t;
            }
            log.printError(defaultError);
            T t = null;
            return t;
        }
        finally {
            log.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T extends SyntaxElement> @Nullable T parse(Iterator<? extends SyntaxElementInfo<? extends T>> source) {
        ParseLogHandler log = SkriptLogger.startParseLogHandler();
        try {
            while (source.hasNext()) {
                SyntaxElementInfo<T> info = source.next();
                block11: for (int i = 0; i < info.patterns.length; ++i) {
                    log.clear();
                    try {
                        ParseResult res;
                        String pattern = info.patterns[i];
                        assert (pattern != null);
                        try {
                            res = this.parse_i(pattern, 0, 0);
                        }
                        catch (MalformedPatternException e) {
                            String message = "pattern compiling exception, element class: " + info.c.getName();
                            try {
                                JavaPlugin providingPlugin = JavaPlugin.getProvidingPlugin(info.c);
                                message = message + " (provided by " + providingPlugin.getName() + ")";
                                throw new RuntimeException(message, e);
                            }
                            catch (IllegalArgumentException | IllegalStateException providingPlugin) {
                                // empty catch block
                            }
                            throw new RuntimeException(message, e);
                        }
                        if (res == null) continue;
                        int x = -1;
                        int j = 0;
                        while ((x = SkriptParser.nextUnescaped(pattern, '%', x + 1)) != -1) {
                            String name;
                            int x2 = SkriptParser.nextUnescaped(pattern, '%', x + 1);
                            if (res.exprs[j] == null && !(name = pattern.substring(x + 1, x2)).startsWith("-")) {
                                ExprInfo vi = SkriptParser.getExprInfo(name);
                                DefaultExpression<?> expr = vi.classes[0].getDefaultExpression();
                                if (expr == null) {
                                    throw new SkriptAPIException("The class '" + vi.classes[0].getCodeName() + "' does not provide a default expression. Either allow null (with %-" + vi.classes[0].getCodeName() + "%) or make it mandatory [pattern: " + info.patterns[i] + "]");
                                }
                                if (!(expr instanceof Literal) && (vi.flagMask & 1) == 0) {
                                    throw new SkriptAPIException("The default expression of '" + vi.classes[0].getCodeName() + "' is not a literal. Either allow null (with %-*" + vi.classes[0].getCodeName() + "%) or make it mandatory [pattern: " + info.patterns[i] + "]");
                                }
                                if (expr instanceof Literal && (vi.flagMask & 2) == 0) {
                                    throw new SkriptAPIException("The default expression of '" + vi.classes[0].getCodeName() + "' is a literal. Either allow null (with %-~" + vi.classes[0].getCodeName() + "%) or make it mandatory [pattern: " + info.patterns[i] + "]");
                                }
                                if (!vi.isPlural[0] && !expr.isSingle()) {
                                    throw new SkriptAPIException("The default expression of '" + vi.classes[0].getCodeName() + "' is not a single-element expression. Change your pattern to allow multiple elements or make the expression mandatory [pattern: " + info.patterns[i] + "]");
                                }
                                if (vi.time != 0 && !expr.setTime(vi.time)) {
                                    throw new SkriptAPIException("The default expression of '" + vi.classes[0].getCodeName() + "' does not have distinct time states. [pattern: " + info.patterns[i] + "]");
                                }
                                if (!expr.init()) continue block11;
                                res.exprs[j] = expr;
                            }
                            x = x2;
                            ++j;
                        }
                        SyntaxElement t = (SyntaxElement)info.c.newInstance();
                        if (!t.init(res.exprs, i, SkriptParser.getParser().getHasDelayBefore(), res)) continue;
                        log.printLog();
                        SyntaxElement syntaxElement = t;
                        return (T)syntaxElement;
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        assert (false);
                        continue;
                    }
                }
            }
            log.printError();
            T t = null;
            return t;
        }
        finally {
            log.stop();
        }
    }

    private static <T> @Nullable Variable<T> parseVariable(String expr, Class<? extends T>[] returnTypes) {
        if (varPattern.matcher(expr).matches()) {
            String variableName = "" + expr.substring(expr.indexOf(123) + 1, expr.lastIndexOf(125));
            boolean inExpression = false;
            int variableDepth = 0;
            for (char c : variableName.toCharArray()) {
                if (c == '%' && variableDepth == 0) {
                    boolean bl = inExpression = !inExpression;
                }
                if (inExpression) {
                    if (c == '{') {
                        ++variableDepth;
                    } else if (c == '}') {
                        --variableDepth;
                    }
                }
                if (inExpression || c != '{' && c != '}') continue;
                return null;
            }
            return Variable.newInstance(variableName, returnTypes);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> @Nullable Expression<? extends T> parseSingleExpr(boolean allowUnparsedLiteral, @Nullable LogEntry error, Class<? extends T> ... types) {
        assert (types.length > 0);
        assert (types.length == 1 || !CollectionUtils.contains(types, Object.class));
        if (this.expr.isEmpty()) {
            return null;
        }
        if (this.context != ParseContext.COMMAND && this.expr.startsWith("(") && this.expr.endsWith(")") && SkriptParser.next(this.expr, 0, this.context) == this.expr.length()) {
            return new SkriptParser(this, "" + this.expr.substring(1, this.expr.length() - 1)).parseSingleExpr(allowUnparsedLiteral, error, types);
        }
        ParseLogHandler log = SkriptLogger.startParseLogHandler();
        try {
            Expression<String> e;
            if (this.context == ParseContext.DEFAULT || this.context == ParseContext.EVENT) {
                Variable<? extends T> var = SkriptParser.parseVariable(this.expr, types);
                if (var != null) {
                    if ((this.flags & 1) == 0) {
                        Skript.error("Variables cannot be used here.");
                        log.printError();
                        Expression<? extends T> expression = null;
                        return expression;
                    }
                    log.printLog();
                    Variable<? extends T> variable = var;
                    return variable;
                }
                if (log.hasError()) {
                    log.printError();
                    Expression<? extends T> expression = null;
                    return expression;
                }
                Class<? extends T>[] fr = this.parseFunction(types);
                if (fr != null) {
                    log.printLog();
                    ExprFunctionCall<? extends T> exprFunctionCall = new ExprFunctionCall<T>(fr);
                    return exprFunctionCall;
                }
                if (log.hasError()) {
                    log.printError();
                    Expression<? extends T> expression = null;
                    return expression;
                }
            }
            log.clear();
            if ((this.flags & 1) != 0) {
                e = this.expr.startsWith("\"") && this.expr.length() != 1 && SkriptParser.nextQuote(this.expr, 1) == this.expr.length() - 1 ? VariableString.newInstance("" + this.expr.substring(1, this.expr.length() - 1)) : (Expression)SkriptParser.parse(this.expr, Skript.getExpressions(types), null);
                if (e != null) {
                    for (Class<T> clazz : types) {
                        if (!clazz.isAssignableFrom(e.getReturnType())) continue;
                        log.printLog();
                        Expression<String> expression = e;
                        return expression;
                    }
                    Class<? extends T>[] objTypes = types;
                    Expression<? extends T> r = e.getConvertedExpression(objTypes);
                    if (r != null) {
                        log.printLog();
                        Expression<? extends T> expression = r;
                        return expression;
                    }
                    log.printError(e.toString(null, false) + " " + Language.get("is") + " " + SkriptParser.notOfType(types), ErrorQuality.NOT_AN_EXPRESSION);
                    Expression<? extends T> expression = null;
                    return expression;
                }
                log.clear();
            }
            if ((this.flags & 2) == 0) {
                log.printError();
                e = null;
                return e;
            }
            if (types[0] == Object.class) {
                if (!allowUnparsedLiteral || Classes.parseSimple(this.expr, Object.class, this.context) == null) {
                    log.printError();
                    e = null;
                    return e;
                }
                log.clear();
                e = log.getError();
                UnparsedLiteral unparsedLiteral = new UnparsedLiteral(this.expr, (LogEntry)(e != null && (error == null || ((LogEntry)((Object)e)).quality > error.quality) ? e : error));
                return unparsedLiteral;
            }
            for (Class<? extends T> c : types) {
                log.clear();
                assert (c != null);
                T t = Classes.parse(this.expr, c, this.context);
                if (t == null) continue;
                log.printLog();
                SimpleLiteral<T> simpleLiteral = new SimpleLiteral<T>(t, false);
                return simpleLiteral;
            }
            log.printError();
            Class<? extends T>[] classArray = null;
            return classArray;
        }
        finally {
            log.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final @Nullable Expression<?> parseSingleExpr(boolean allowUnparsedLiteral, @Nullable LogEntry error, ExprInfo vi) {
        if (this.expr.isEmpty()) {
            return null;
        }
        if (this.context != ParseContext.COMMAND && this.expr.startsWith("(") && this.expr.endsWith(")") && SkriptParser.next(this.expr, 0, this.context) == this.expr.length()) {
            return new SkriptParser(this, "" + this.expr.substring(1, this.expr.length() - 1)).parseSingleExpr(allowUnparsedLiteral, error, vi);
        }
        ParseLogHandler log = SkriptLogger.startParseLogHandler();
        try {
            Expression<String> e;
            Class[] types = new Class[vi.classes.length];
            boolean hasSingular = false;
            boolean hasPlural = false;
            Class[] nonNullTypes = new Class[vi.classes.length];
            int nonNullIndex = 0;
            for (int i = 0; i < types.length; ++i) {
                if ((this.flags & vi.flagMask) == 0) continue;
                if (vi.isPlural[i]) {
                    hasPlural = true;
                } else {
                    hasSingular = true;
                }
                types[i] = vi.classes[i].getC();
                nonNullTypes[nonNullIndex] = types[i];
                ++nonNullIndex;
            }
            boolean onlyPlural = false;
            boolean onlySingular = false;
            if (hasSingular && !hasPlural) {
                onlySingular = true;
            } else if (!hasSingular && hasPlural) {
                onlyPlural = true;
            }
            if (this.context == ParseContext.DEFAULT || this.context == ParseContext.EVENT) {
                Variable var;
                if (onlySingular || onlyPlural) {
                    var = SkriptParser.parseVariable(this.expr, nonNullTypes);
                    if (var != null) {
                        if ((this.flags & 1) == 0) {
                            Skript.error("Variables cannot be used here.");
                            log.printError();
                            Expression<?> expression = null;
                            return expression;
                        }
                        if (hasSingular && !var.isSingle()) {
                            Skript.error("'" + this.expr + "' can only accept a single value of any type, not more", ErrorQuality.SEMANTIC_ERROR);
                            Expression<?> expression = null;
                            return expression;
                        }
                        log.printLog();
                        Variable variable = var;
                        return variable;
                    }
                    if (log.hasError()) {
                        log.printError();
                        Expression<?> expression = null;
                        return expression;
                    }
                } else {
                    var = SkriptParser.parseVariable(this.expr, types);
                    if (var != null) {
                        if ((this.flags & 1) == 0) {
                            Skript.error("Variables cannot be used here.");
                            log.printError();
                            Expression<?> expression = null;
                            return expression;
                        }
                        if ((vi.classes.length == 1 && !vi.isPlural[0] || Booleans.contains((boolean[])vi.isPlural, (boolean)true)) && !var.isSingle()) {
                            Skript.error("'" + this.expr + "' can only accept a single " + Classes.toString(Stream.of(vi.classes).map(ci -> ci.getName().toString()).toArray(), false) + ", not more", ErrorQuality.SEMANTIC_ERROR);
                            Expression<?> expression = null;
                            return expression;
                        }
                        log.printLog();
                        Variable variable = var;
                        return variable;
                    }
                    if (log.hasError()) {
                        log.printError();
                        Expression<?> expression = null;
                        return expression;
                    }
                }
                FunctionReference fr = this.parseFunction(types);
                if (fr != null) {
                    log.printLog();
                    ExprFunctionCall exprFunctionCall = new ExprFunctionCall(fr);
                    return exprFunctionCall;
                }
                if (log.hasError()) {
                    log.printError();
                    Expression<?> expression = null;
                    return expression;
                }
            }
            log.clear();
            if ((this.flags & 1) != 0) {
                e = this.expr.startsWith("\"") && this.expr.length() != 1 && SkriptParser.nextQuote(this.expr, 1) == this.expr.length() - 1 ? VariableString.newInstance("" + this.expr.substring(1, this.expr.length() - 1)) : (Expression)SkriptParser.parse(this.expr, Skript.getExpressions(types), null);
                if (e != null) {
                    Object t;
                    Class returnType = e.getReturnType();
                    assert (returnType != null);
                    for (int i = 0; i < types.length; ++i) {
                        t = types[i];
                        if (t == null || !((Class)t).isAssignableFrom(returnType)) continue;
                        if (!vi.isPlural[i] && !e.isSingle()) {
                            if (this.context == ParseContext.COMMAND) {
                                Skript.error(Commands.m_too_many_arguments.toString(vi.classes[i].getName().getIndefiniteArticle(), vi.classes[i].getName().toString()), ErrorQuality.SEMANTIC_ERROR);
                                Expression<?> expression = null;
                                return expression;
                            }
                            Skript.error("'" + this.expr + "' can only accept a single " + vi.classes[i].getName() + ", not more", ErrorQuality.SEMANTIC_ERROR);
                            Expression<?> expression = null;
                            return expression;
                        }
                        log.printLog();
                        Expression<String> expression = e;
                        return expression;
                    }
                    if (onlySingular && !e.isSingle()) {
                        Skript.error("'" + this.expr + "' can only accept singular expressions, not plural", ErrorQuality.SEMANTIC_ERROR);
                        Expression<?> i = null;
                        return i;
                    }
                    Expression r = e.getConvertedExpression(types);
                    if (r != null) {
                        log.printLog();
                        t = r;
                        return t;
                    }
                    log.printError(e.toString(null, false) + " " + Language.get("is") + " " + SkriptParser.notOfType(types), ErrorQuality.NOT_AN_EXPRESSION);
                    t = null;
                    return t;
                }
                log.clear();
            }
            if ((this.flags & 2) == 0) {
                log.printError();
                e = null;
                return e;
            }
            if (vi.classes[0].getC() == Object.class) {
                if (!allowUnparsedLiteral || Classes.parseSimple(this.expr, Object.class, this.context) == null) {
                    log.printError();
                    e = null;
                    return e;
                }
                log.clear();
                e = log.getError();
                UnparsedLiteral unparsedLiteral = new UnparsedLiteral(this.expr, (LogEntry)(e != null && (error == null || ((LogEntry)((Object)e)).quality > error.quality) ? e : error));
                return unparsedLiteral;
            }
            for (ClassInfo<?> ci2 : vi.classes) {
                log.clear();
                assert (ci2.getC() != null);
                Object t = Classes.parse(this.expr, ci2.getC(), this.context);
                if (t == null) continue;
                log.printLog();
                SimpleLiteral simpleLiteral = new SimpleLiteral(t, false, new UnparsedLiteral(this.expr));
                return simpleLiteral;
            }
            log.printError();
            ClassInfo<?>[] classInfoArray = null;
            return classInfoArray;
        }
        finally {
            log.stop();
        }
    }

    private SkriptParser suppressMissingAndOrWarnings() {
        this.suppressMissingAndOrWarnings = true;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> @Nullable Expression<? extends T> parseExpression(Class<? extends T> ... types) {
        if (this.expr.length() == 0) {
            return null;
        }
        assert (types != null && types.length > 0);
        assert (types.length == 1 || !CollectionUtils.contains(types, Object.class));
        boolean isObject = types.length == 1 && types[0] == Object.class;
        ParseLogHandler log = SkriptLogger.startParseLogHandler();
        try {
            int a2;
            Expression<? extends T> r = this.parseSingleExpr(true, null, types);
            if (r != null) {
                log.printLog();
                Expression<? extends T> expression = r;
                return expression;
            }
            log.clear();
            ArrayList<Expression<? extends T>> ts = new ArrayList<Expression<? extends T>>();
            Kleenean and = Kleenean.UNKNOWN;
            boolean isLiteralList = true;
            ArrayList<int[]> pieces = new ArrayList<int[]>();
            Expression<? extends T> m = LIST_SPLIT_PATTERN.matcher(this.expr);
            int i = 0;
            int j = 0;
            while (i >= 0 && i <= this.expr.length()) {
                if (i == this.expr.length() || ((Matcher)((Object)m)).region(i, this.expr.length()).lookingAt()) {
                    pieces.add(new int[]{j, i});
                    if (i == this.expr.length()) break;
                    j = i = ((Matcher)((Object)m)).end();
                }
                i = SkriptParser.next(this.expr, i, this.context);
            }
            if (i != this.expr.length()) {
                assert (i == -1 && this.context != ParseContext.COMMAND) : i + "; " + this.expr;
                log.printError("Invalid brackets/variables/text in '" + this.expr + "'", ErrorQuality.NOT_AN_EXPRESSION);
                Expression<? extends T> expression = null;
                return expression;
            }
            if (pieces.size() == 1) {
                if (this.expr.startsWith("(") && this.expr.endsWith(")") && SkriptParser.next(this.expr, 0, this.context) == this.expr.length()) {
                    log.clear();
                    m = new SkriptParser(this, "" + this.expr.substring(1, this.expr.length() - 1)).parseExpression(types);
                    return m;
                }
                if (isObject && (this.flags & 2) != 0) {
                    log.clear();
                    m = new UnparsedLiteral(this.expr, log.getError());
                    return m;
                }
                log.printError();
                m = null;
                return m;
            }
            block12: for (int b = 0; b < pieces.size(); b += a2) {
                for (a2 = 1; a2 <= pieces.size() - b; ++a2) {
                    boolean or;
                    String delimiter;
                    if (b == 0 && a2 == pieces.size()) continue;
                    int x = ((int[])pieces.get(b))[0];
                    int y = ((int[])pieces.get(b + a2 - 1))[1];
                    String subExpr = "" + this.expr.substring(x, y).trim();
                    assert (subExpr.length() < this.expr.length()) : subExpr;
                    Expression<? extends T> t = subExpr.startsWith("(") && subExpr.endsWith(")") && SkriptParser.next(subExpr, 0, this.context) == subExpr.length() ? new SkriptParser(this, subExpr).parseExpression(types) : new SkriptParser(this, subExpr).parseSingleExpr(a2 == 1, log.getError(), types);
                    if (t == null) continue;
                    isLiteralList &= t instanceof Literal;
                    ts.add(t);
                    if (b == 0 || (delimiter = this.expr.substring(((int[])pieces.get(b - 1))[1], x).trim().toLowerCase(Locale.ENGLISH)).equals(",")) continue block12;
                    boolean bl = or = !delimiter.contains("nor") && delimiter.endsWith("or");
                    if (and.isUnknown()) {
                        and = Kleenean.get(!or);
                        continue block12;
                    }
                    if (and == Kleenean.get(!or)) continue block12;
                    Skript.warning("List has multiple 'and' or 'or', will default to 'and'. Use brackets if you want to define multiple lists. List: " + this.expr);
                    and = Kleenean.TRUE;
                    continue block12;
                }
                log.printError();
                Expression<? extends T> a2 = null;
                return a2;
            }
            log.printLog(false);
            if (ts.size() == 1) {
                Expression b = (Expression)ts.get(0);
                return b;
            }
            if (and.isUnknown() && !this.suppressMissingAndOrWarnings) {
                Script currentScript;
                ParserInstance parser = SkriptParser.getParser();
                Script script = currentScript = parser.isActive() ? parser.getCurrentScript() : null;
                if (currentScript == null || !currentScript.suppressesWarning(ScriptWarning.MISSING_CONJUNCTION)) {
                    Skript.warning("List is missing 'and' or 'or', defaulting to 'and': " + this.expr);
                }
            }
            Class[] exprRetTypes = new Class[ts.size()];
            for (i = 0; i < ts.size(); ++i) {
                exprRetTypes[i] = ((Expression)ts.get(i)).getReturnType();
            }
            if (isLiteralList) {
                Literal[] ls = ts.toArray(new Literal[ts.size()]);
                assert (ls != null);
                LiteralList literalList = new LiteralList(ls, Utils.getSuperType(exprRetTypes), !and.isFalse());
                return literalList;
            }
            Expression[] es = ts.toArray(new Expression[ts.size()]);
            assert (es != null);
            ExpressionList expressionList = new ExpressionList(es, Utils.getSuperType(exprRetTypes), !and.isFalse());
            return expressionList;
        }
        finally {
            log.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final @Nullable Expression<?> parseExpression(ExprInfo vi) {
        if (this.expr.length() == 0) {
            return null;
        }
        boolean isObject = vi.classes.length == 1 && vi.classes[0].getC() == Object.class;
        ParseLogHandler log = SkriptLogger.startParseLogHandler();
        try {
            int a2;
            Expression<?> r = this.parseSingleExpr(true, null, vi);
            if (r != null) {
                log.printLog();
                Expression<?> expression = r;
                return expression;
            }
            log.clear();
            ArrayList ts = new ArrayList();
            Kleenean and = Kleenean.UNKNOWN;
            boolean isLiteralList = true;
            ArrayList<int[]> pieces = new ArrayList<int[]>();
            Expression<?> m = LIST_SPLIT_PATTERN.matcher(this.expr);
            int i = 0;
            int j = 0;
            while (i >= 0 && i <= this.expr.length()) {
                if (i == this.expr.length() || ((Matcher)((Object)m)).region(i, this.expr.length()).lookingAt()) {
                    pieces.add(new int[]{j, i});
                    if (i == this.expr.length()) break;
                    j = i = ((Matcher)((Object)m)).end();
                }
                i = SkriptParser.next(this.expr, i, this.context);
            }
            if (i != this.expr.length()) {
                assert (i == -1 && this.context != ParseContext.COMMAND) : i + "; " + this.expr;
                log.printError("Invalid brackets/variables/text in '" + this.expr + "'", ErrorQuality.NOT_AN_EXPRESSION);
                Expression<?> expression = null;
                return expression;
            }
            if (pieces.size() == 1) {
                if (this.expr.startsWith("(") && this.expr.endsWith(")") && SkriptParser.next(this.expr, 0, this.context) == this.expr.length()) {
                    log.clear();
                    m = new SkriptParser(this, "" + this.expr.substring(1, this.expr.length() - 1)).parseExpression(vi);
                    return m;
                }
                if (isObject && (this.flags & 2) != 0) {
                    log.clear();
                    m = new UnparsedLiteral(this.expr, log.getError());
                    return m;
                }
                log.printError();
                m = null;
                return m;
            }
            if (!vi.isPlural[0] && !OR_PATTERN.matcher(this.expr).find()) {
                log.printError();
                m = null;
                return m;
            }
            block14: for (int b = 0; b < pieces.size(); b += a2) {
                for (a2 = 1; a2 <= pieces.size() - b; ++a2) {
                    boolean or;
                    String delimiter;
                    if (b == 0 && a2 == pieces.size()) continue;
                    int x = ((int[])pieces.get(b))[0];
                    int y = ((int[])pieces.get(b + a2 - 1))[1];
                    String subExpr = "" + this.expr.substring(x, y).trim();
                    assert (subExpr.length() < this.expr.length()) : subExpr;
                    Expression<?> t = subExpr.startsWith("(") && subExpr.endsWith(")") && SkriptParser.next(subExpr, 0, this.context) == subExpr.length() ? new SkriptParser(this, subExpr).parseExpression(vi) : new SkriptParser(this, subExpr).parseSingleExpr(a2 == 1, log.getError(), vi);
                    if (t == null) continue;
                    isLiteralList &= t instanceof Literal;
                    ts.add(t);
                    if (b == 0 || (delimiter = this.expr.substring(((int[])pieces.get(b - 1))[1], x).trim().toLowerCase(Locale.ENGLISH)).equals(",")) continue block14;
                    boolean bl = or = !delimiter.contains("nor") && delimiter.endsWith("or");
                    if (and.isUnknown()) {
                        and = Kleenean.get(!or);
                        continue block14;
                    }
                    if (and == Kleenean.get(!or)) continue block14;
                    Skript.warning("List has multiple 'and' or 'or', will default to 'and'. Use brackets if you want to define multiple lists. List: " + this.expr);
                    and = Kleenean.TRUE;
                    continue block14;
                }
                log.printError();
                Expression<?> a2 = null;
                return a2;
            }
            if (!vi.isPlural[0] && !and.isFalse()) {
                log.printError();
                Expression<?> b = null;
                return b;
            }
            log.printLog(false);
            if (ts.size() == 1) {
                Expression b = (Expression)ts.get(0);
                return b;
            }
            if (and.isUnknown() && !this.suppressMissingAndOrWarnings) {
                Script currentScript;
                ParserInstance parser = SkriptParser.getParser();
                Script script = currentScript = parser.isActive() ? parser.getCurrentScript() : null;
                if (currentScript == null || !currentScript.suppressesWarning(ScriptWarning.MISSING_CONJUNCTION)) {
                    Skript.warning("List is missing 'and' or 'or', defaulting to 'and': " + this.expr);
                }
            }
            Class[] exprRetTypes = new Class[ts.size()];
            for (i = 0; i < ts.size(); ++i) {
                exprRetTypes[i] = ((Expression)ts.get(i)).getReturnType();
            }
            if (isLiteralList) {
                Literal[] ls = ts.toArray(new Literal[ts.size()]);
                assert (ls != null);
                LiteralList literalList = new LiteralList(ls, Utils.getSuperType(exprRetTypes), !and.isFalse());
                return literalList;
            }
            Expression[] es = ts.toArray(new Expression[ts.size()]);
            assert (es != null);
            ExpressionList expressionList = new ExpressionList(es, Utils.getSuperType(exprRetTypes), !and.isFalse());
            return expressionList;
        }
        finally {
            log.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> @Nullable FunctionReference<T> parseFunction(Class<? extends T> ... types) {
        if (this.context != ParseContext.DEFAULT && this.context != ParseContext.EVENT) {
            return null;
        }
        ParseLogHandler log = SkriptLogger.startParseLogHandler();
        try {
            Expression[] params;
            Matcher m = functionCallPattern.matcher(this.expr);
            if (!m.matches()) {
                log.printLog();
                FunctionReference<T> functionReference = null;
                return functionReference;
            }
            String functionName = "" + m.group(1);
            String args = m.group(2);
            int i2 = 0;
            while (i2 < args.length()) {
                if (i2 == -1) {
                    log.printLog();
                    FunctionReference<T> functionReference = null;
                    return functionReference;
                }
                i2 = SkriptParser.next(args, i2, this.context);
            }
            if ((this.flags & 1) == 0) {
                Skript.error("Functions cannot be used here (or there is a problem with your arguments).");
                log.printError();
                FunctionReference<T> i2 = null;
                return i2;
            }
            if (args.length() != 0) {
                Expression<T> ps = new SkriptParser(args, this.flags | 2, this.context).suppressMissingAndOrWarnings().parseExpression(Object.class);
                if (ps == null) {
                    log.printError();
                    FunctionReference<T> functionReference = null;
                    return functionReference;
                }
                if (ps instanceof ExpressionList) {
                    if (!ps.getAnd()) {
                        Skript.error("Function arguments must be separated by commas and optionally an 'and', but not an 'or'. Put the 'or' into a second set of parentheses if you want to make it a single parameter, e.g. 'give(player, (sword or axe))'");
                        log.printError();
                        FunctionReference<T> functionReference = null;
                        return functionReference;
                    }
                    params = ((ExpressionList)ps).getExpressions();
                } else {
                    params = new Expression[]{ps};
                }
            } else {
                params = new Expression[]{};
            }
            ParserInstance parser = SkriptParser.getParser();
            Script currentScript = parser.isActive() ? parser.getCurrentScript() : null;
            FunctionReference<T> e = new FunctionReference<T>(functionName, SkriptLogger.getNode(), currentScript != null ? currentScript.getConfig().getFileName() : null, types, params);
            if (!e.validateFunction(true)) {
                log.printError();
                FunctionReference<T> functionReference = null;
                return functionReference;
            }
            log.printLog();
            FunctionReference<T> functionReference = e;
            return functionReference;
        }
        finally {
            log.stop();
        }
    }

    public static boolean parseArguments(String args, ScriptCommand command, ScriptCommandEvent event) {
        SkriptParser parser = new SkriptParser(args, 2, ParseContext.COMMAND);
        ParseResult res = parser.parse_i(command.getPattern(), 0, 0);
        if (res == null) {
            return false;
        }
        List<Argument<?>> as = command.getArguments();
        assert (as.size() == res.exprs.length);
        for (int i = 0; i < res.exprs.length; ++i) {
            if (res.exprs[i] == null) {
                as.get(i).setToDefault(event);
                continue;
            }
            as.get(i).set(event, res.exprs[i].getArray(event));
        }
        return true;
    }

    public static @Nullable ParseResult parse(String text, String pattern) {
        return new SkriptParser(text, 2, ParseContext.COMMAND).parse_i(pattern, 0, 0);
    }

    public static int nextBracket(String pattern, char closingBracket, char openingBracket, int start, boolean isGroup) throws MalformedPatternException {
        int n = 0;
        for (int i = start; i < pattern.length(); ++i) {
            if (pattern.charAt(i) == '\\') {
                ++i;
                continue;
            }
            if (pattern.charAt(i) == closingBracket) {
                if (n == 0) {
                    if (!isGroup) {
                        throw new MalformedPatternException(pattern, "Unexpected closing bracket '" + closingBracket + "'");
                    }
                    return i;
                }
                --n;
                continue;
            }
            if (pattern.charAt(i) != openingBracket) continue;
            ++n;
        }
        if (isGroup) {
            throw new MalformedPatternException(pattern, "Missing closing bracket '" + closingBracket + "'");
        }
        return -1;
    }

    private static int nextUnescaped(String pattern, char c, int from) {
        for (int i = from; i < pattern.length(); ++i) {
            if (pattern.charAt(i) == '\\') {
                ++i;
                continue;
            }
            if (pattern.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    static int countUnescaped(String pattern, char c) {
        return SkriptParser.countUnescaped(pattern, c, 0, pattern.length());
    }

    static int countUnescaped(String pattern, char c, int start, int end) {
        assert (start >= 0 && start <= end && end <= pattern.length()) : start + ", " + end + "; " + pattern.length();
        int r = 0;
        for (int i = start; i < end; ++i) {
            char x = pattern.charAt(i);
            if (x == '\\') {
                ++i;
                continue;
            }
            if (x != c) continue;
            ++r;
        }
        return r;
    }

    private static int nextQuote(String s, int from) {
        boolean inExpression = false;
        for (int i = from; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\"' && !inExpression) {
                if (i == s.length() - 1 || s.charAt(i + 1) != '\"') {
                    return i;
                }
                ++i;
                continue;
            }
            if (c != '%') continue;
            inExpression = !inExpression;
        }
        return -1;
    }

    public static String notOfType(Class<?> ... cs) {
        if (cs.length == 1) {
            Class<?> c = cs[0];
            assert (c != null);
            return Language.get("not") + " " + Classes.getSuperClassInfo(c).getName().withIndefiniteArticle();
        }
        StringBuilder b = new StringBuilder(Language.get("neither") + " ");
        for (int k = 0; k < cs.length; ++k) {
            if (k != 0) {
                if (k != cs.length - 1) {
                    b.append(", ");
                } else {
                    b.append(" " + Language.get("nor") + " ");
                }
            }
            Class<?> c = cs[k];
            assert (c != null);
            b.append(Classes.getSuperClassInfo(c).getName().withIndefiniteArticle());
        }
        return "" + b.toString();
    }

    public static String notOfType(ClassInfo<?> ... cs) {
        if (cs.length == 1) {
            return Language.get("not") + " " + cs[0].getName().withIndefiniteArticle();
        }
        StringBuilder b = new StringBuilder(Language.get("neither") + " ");
        for (int k = 0; k < cs.length; ++k) {
            if (k != 0) {
                if (k != cs.length - 1) {
                    b.append(", ");
                } else {
                    b.append(" " + Language.get("nor") + " ");
                }
            }
            b.append(cs[k].getName().withIndefiniteArticle());
        }
        return "" + b.toString();
    }

    public static int next(String expr, int startIndex, ParseContext context) {
        if (startIndex < 0) {
            throw new StringIndexOutOfBoundsException(startIndex);
        }
        int exprLength = expr.length();
        if (startIndex >= exprLength) {
            return -1;
        }
        if (context == ParseContext.COMMAND) {
            return startIndex + 1;
        }
        switch (expr.charAt(startIndex)) {
            case '\"': {
                int j = SkriptParser.nextQuote(expr, startIndex + 1);
                return j < 0 ? -1 : j + 1;
            }
            case '{': {
                int j = VariableString.nextVariableBracket(expr, startIndex + 1);
                return j < 0 ? -1 : j + 1;
            }
            case '(': {
                int j = startIndex + 1;
                while (j >= 0 && j < exprLength) {
                    if (expr.charAt(j) == ')') {
                        return j + 1;
                    }
                    j = SkriptParser.next(expr, j, context);
                }
                return -1;
            }
        }
        return startIndex + 1;
    }

    public static int nextOccurrence(String haystack, String needle, int startIndex, ParseContext parseContext, boolean caseSensitive) {
        char firstChar;
        boolean startsWithSpecialChar;
        if (startIndex < 0) {
            throw new StringIndexOutOfBoundsException(startIndex);
        }
        if (parseContext == ParseContext.COMMAND) {
            return haystack.indexOf(needle, startIndex);
        }
        int haystackLength = haystack.length();
        if (startIndex >= haystackLength) {
            return -1;
        }
        if (!caseSensitive) {
            haystack = haystack.toLowerCase(Locale.ENGLISH);
            needle = needle.toLowerCase(Locale.ENGLISH);
        }
        boolean bl = startsWithSpecialChar = (firstChar = needle.charAt(0)) == '\"' || firstChar == '{' || firstChar == '(';
        while (startIndex < haystackLength) {
            char c = haystack.charAt(startIndex);
            if (startsWithSpecialChar && haystack.startsWith(needle, startIndex)) {
                return startIndex;
            }
            switch (c) {
                case '\"': {
                    startIndex = SkriptParser.nextQuote(haystack, startIndex + 1);
                    if (startIndex >= 0) break;
                    return -1;
                }
                case '{': {
                    startIndex = VariableString.nextVariableBracket(haystack, startIndex + 1);
                    if (startIndex >= 0) break;
                    return -1;
                }
                case '(': {
                    startIndex = SkriptParser.next(haystack, startIndex, parseContext);
                    if (startIndex >= 0) break;
                    return -1;
                }
            }
            if (haystack.startsWith(needle, startIndex)) {
                return startIndex;
            }
            ++startIndex;
        }
        return -1;
    }

    private @Nullable ParseResult parse_i(String pattern, int i, int j) {
        if (i != 0 || j != 0) {
            throw new IllegalArgumentException();
        }
        SkriptPattern skriptPattern = patterns.computeIfAbsent(pattern, PatternCompiler::compile);
        MatchResult matchResult = skriptPattern.match(this.expr, this.flags, this.context);
        if (matchResult == null) {
            return null;
        }
        return matchResult.toParseResult();
    }

    public static @Nullable NonNullPair<String, boolean[]> validatePattern(String pattern) {
        ArrayList<Boolean> ps = new ArrayList<Boolean>();
        int groupLevel = 0;
        int optionalLevel = 0;
        LinkedList<Character> groups = new LinkedList<Character>();
        StringBuilder b = new StringBuilder(pattern.length());
        int last = 0;
        for (int i = 0; i < pattern.length(); ++i) {
            int j;
            char c = pattern.charAt(i);
            if (c == '(') {
                ++groupLevel;
                groups.addLast(Character.valueOf(c));
                continue;
            }
            if (c == '|') {
                if (groupLevel == 0 || ((Character)groups.peekLast()).charValue() != '(' && ((Character)groups.peekLast()).charValue() != '|') {
                    return SkriptParser.error("Cannot use the pipe character '|' outside of groups. Escape it if you want to match a literal pipe: '\\|'");
                }
                groups.removeLast();
                groups.addLast(Character.valueOf(c));
                continue;
            }
            if (c == ')') {
                if (groupLevel == 0 || ((Character)groups.peekLast()).charValue() != '(' && ((Character)groups.peekLast()).charValue() != '|') {
                    return SkriptParser.error("Unexpected closing group bracket ')'. Escape it if you want to match a literal bracket: '\\)'");
                }
                if (((Character)groups.peekLast()).charValue() == '(') {
                    return SkriptParser.error("(...|...) groups have to contain at least one pipe character '|' to separate it into parts. Escape the brackets if you want to match literal brackets: \"\\(not a group\\)\"");
                }
                --groupLevel;
                groups.removeLast();
                continue;
            }
            if (c == '[') {
                ++optionalLevel;
                groups.addLast(Character.valueOf(c));
                continue;
            }
            if (c == ']') {
                if (optionalLevel == 0 || ((Character)groups.peekLast()).charValue() != '[') {
                    return SkriptParser.error("Unexpected closing optional bracket ']'. Escape it if you want to match a literal bracket: '\\]'");
                }
                --optionalLevel;
                groups.removeLast();
                continue;
            }
            if (c == '<') {
                j = pattern.indexOf(62, i + 1);
                if (j == -1) {
                    return SkriptParser.error("Missing closing regex bracket '>'. Escape the '<' if you want to match a literal bracket: '\\<'");
                }
                try {
                    Pattern.compile(pattern.substring(i + 1, j));
                }
                catch (PatternSyntaxException e) {
                    return SkriptParser.error("Invalid Regular Expression '" + pattern.substring(i + 1, j) + "': " + e.getLocalizedMessage());
                }
                i = j;
                continue;
            }
            if (c == '>') {
                return SkriptParser.error("Unexpected closing regex bracket '>'. Escape it if you want to match a literal bracket: '\\>'");
            }
            if (c == '%') {
                j = pattern.indexOf(37, i + 1);
                if (j == -1) {
                    return SkriptParser.error("Missing end sign '%' of expression. Escape the percent sign to match a literal '%': '\\%'");
                }
                NonNullPair<String, Boolean> p = Utils.getEnglishPlural("" + pattern.substring(i + 1, j));
                ClassInfo<?> ci = Classes.getClassInfoFromUserInput(p.getFirst());
                if (ci == null) {
                    return SkriptParser.error("The type '" + p.getFirst() + "' could not be found. Please check your spelling or escape the percent signs if you want to match literal %s: \"\\%not an expression\\%\"");
                }
                ps.add(p.getSecond());
                b.append(pattern.substring(last, i + 1));
                b.append(Utils.toEnglishPlural(ci.getCodeName(), p.getSecond()));
                last = j;
                i = j;
                continue;
            }
            if (c != '\\') continue;
            if (i == pattern.length() - 1) {
                return SkriptParser.error("Pattern must not end in an unescaped backslash. Add another backslash to escape it, or remove it altogether.");
            }
            ++i;
        }
        b.append(pattern.substring(last));
        boolean[] plurals = new boolean[ps.size()];
        for (int i = 0; i < plurals.length; ++i) {
            plurals[i] = (Boolean)ps.get(i);
        }
        return new NonNullPair<String, boolean[]>("" + b.toString(), plurals);
    }

    private static @Nullable NonNullPair<String, boolean[]> error(String error) {
        Skript.error("Invalid pattern: " + error);
        return null;
    }

    public static boolean validateLine(String line) {
        if (StringUtils.count(line, '\"') % 2 != 0) {
            Skript.error(m_quotes_error.toString());
            return false;
        }
        int i = 0;
        while (i < line.length()) {
            if (i == -1) {
                Skript.error(m_brackets_error.toString());
                return false;
            }
            i = SkriptParser.next(line, i, ParseContext.DEFAULT);
        }
        return true;
    }

    private static ExprInfo getExprInfo(String s) throws IllegalArgumentException, SkriptAPIException {
        ExprInfo r = exprInfoCache.get(s);
        if (r == null) {
            r = SkriptParser.createExprInfo(s);
            exprInfoCache.put(s, r);
        }
        return r;
    }

    private static ExprInfo createExprInfo(String s) throws IllegalArgumentException, SkriptAPIException {
        int a;
        ExprInfo r = new ExprInfo(StringUtils.count(s, '/') + 1);
        r.isOptional = s.startsWith("-");
        if (r.isOptional) {
            s = "" + s.substring(1);
        }
        if (s.startsWith("*")) {
            s = "" + s.substring(1);
            r.flagMask &= 0xFFFFFFFE;
        } else if (s.startsWith("~")) {
            s = "" + s.substring(1);
            r.flagMask &= 0xFFFFFFFD;
        }
        if (!r.isOptional) {
            r.isOptional = s.startsWith("-");
            if (r.isOptional) {
                s = "" + s.substring(1);
            }
        }
        if ((a = s.indexOf("@")) != -1) {
            r.time = Integer.parseInt(s.substring(a + 1));
            s = "" + s.substring(0, a);
        }
        String[] classes = s.split("/");
        assert (classes.length == r.classes.length);
        for (int i = 0; i < classes.length; ++i) {
            NonNullPair<String, Boolean> p = Utils.getEnglishPlural("" + classes[i]);
            r.classes[i] = Classes.getClassInfo(p.getFirst());
            r.isPlural[i] = p.getSecond();
        }
        return r;
    }

    private static ParserInstance getParser() {
        return ParserInstance.get();
    }

    public static final class ParseResult {
        public final Expression<?>[] exprs;
        public final List<java.util.regex.MatchResult> regexes = new ArrayList<java.util.regex.MatchResult>(1);
        public String expr;
        public int mark = 0;
        public List<String> tags = new ArrayList<String>();

        public ParseResult(SkriptParser parser, String pattern) {
            this.expr = parser.expr;
            this.exprs = new Expression[SkriptParser.countUnescaped(pattern, '%') / 2];
        }

        public ParseResult(String expr, Expression<?>[] expressions) {
            this.expr = expr;
            this.exprs = expressions;
        }

        public boolean hasTag(String tag) {
            return this.tags.contains(tag);
        }
    }

    public static class ExprInfo {
        public final ClassInfo<?>[] classes;
        public final boolean[] isPlural;
        public boolean isOptional;
        public int flagMask = -1;
        public int time = 0;

        public ExprInfo(int length) {
            this.classes = new ClassInfo[length];
            this.isPlural = new boolean[length];
        }
    }
}

