/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang;

import ch.njol.skript.lang.SyntaxElement;
import java.util.Arrays;

public class SyntaxElementInfo<E extends SyntaxElement> {
    public final Class<E> c;
    public final String[] patterns;
    public final String originClassPath;

    public SyntaxElementInfo(String[] patterns, Class<E> c, String originClassPath) throws IllegalArgumentException {
        this.patterns = patterns;
        this.c = c;
        this.originClassPath = originClassPath;
        try {
            c.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new Error(c + " does not have a public nullary constructor", e);
        }
        catch (SecurityException e) {
            throw new IllegalStateException("Skript cannot run properly because a security manager is blocking it!");
        }
    }

    public Class<E> getElementClass() {
        return this.c;
    }

    public String[] getPatterns() {
        return Arrays.copyOf(this.patterns, this.patterns.length);
    }

    public String getOriginClassPath() {
        return this.originClassPath;
    }
}

