/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang.util;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAPIException;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.util.ConvertedExpression;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.Utils;
import ch.njol.util.Checker;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import ch.njol.util.coll.iterator.ArrayIterator;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Iterator;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

public abstract class SimpleExpression<T>
implements Expression<T> {
    private int time = 0;
    private @Nullable ClassInfo<?> returnTypeInfo;

    protected SimpleExpression() {
    }

    @Override
    public final @Nullable T getSingle(Event e) {
        T[] all = this.getArray(e);
        if (all.length == 0) {
            return null;
        }
        if (all.length > 1) {
            throw new SkriptAPIException("Call to getSingle() on a non-single expression");
        }
        return all[0];
    }

    @Override
    public T[] getAll(Event e) {
        T[] all = this.get(e);
        if (all == null) {
            Object[] r = (Object[])Array.newInstance(this.getReturnType(), 0);
            assert (r != null);
            return r;
        }
        if (all.length == 0) {
            return all;
        }
        int numNonNull = 0;
        for (T t : all) {
            if (t == null) continue;
            ++numNonNull;
        }
        if (numNonNull == all.length) {
            return Arrays.copyOf(all, all.length);
        }
        Object[] r = (Object[])Array.newInstance(this.getReturnType(), numNonNull);
        assert (r != null);
        int i = 0;
        for (T t : all) {
            if (t == null) continue;
            r[i++] = t;
        }
        return r;
    }

    @Override
    public final T[] getArray(Event e) {
        T[] all = this.get(e);
        if (all == null) {
            Object[] r = (Object[])Array.newInstance(this.getReturnType(), 0);
            assert (r != null);
            return r;
        }
        if (all.length == 0) {
            return all;
        }
        int numNonNull = 0;
        for (T t : all) {
            if (t == null) continue;
            ++numNonNull;
        }
        if (!this.getAnd()) {
            if (all.length == 1 && all[0] != null) {
                return Arrays.copyOf(all, 1);
            }
            int rand = Utils.random(0, numNonNull);
            Object[] one = (Object[])Array.newInstance(this.getReturnType(), 1);
            T[] TArray = all;
            int n = TArray.length;
            for (int i = 0; i < n; ++i) {
                T t = TArray[i];
                if (t == null) continue;
                if (rand == 0) {
                    one[0] = t;
                    return one;
                }
                --rand;
            }
            assert (false);
        }
        if (numNonNull == all.length) {
            return Arrays.copyOf(all, all.length);
        }
        Object[] r = (Object[])Array.newInstance(this.getReturnType(), numNonNull);
        assert (r != null);
        int i = 0;
        for (T t : all) {
            if (t == null) continue;
            r[i++] = t;
        }
        return r;
    }

    protected abstract @Nullable T[] get(Event var1);

    @Override
    public final boolean check(Event e, Checker<? super T> c) {
        return this.check(e, c, false);
    }

    @Override
    public final boolean check(Event e, Checker<? super T> c, boolean negated) {
        return SimpleExpression.check(this.get(e), c, negated, this.getAnd());
    }

    public static <T> boolean check(@Nullable T[] all, Checker<? super T> c, boolean invert, boolean and) {
        if (all == null) {
            return invert;
        }
        boolean hasElement = false;
        for (T t : all) {
            if (t == null) continue;
            hasElement = true;
            boolean b = c.check(t);
            if (and && !b) {
                return invert;
            }
            if (and || !b) continue;
            return !invert;
        }
        if (!hasElement) {
            return invert;
        }
        return invert ^ and;
    }

    protected <R> @Nullable ConvertedExpression<T, ? extends R> getConvertedExpr(Class<R> ... to) {
        assert (!CollectionUtils.containsSuperclass(to, this.getReturnType()));
        return ConvertedExpression.newInstance(this, to);
    }

    @Override
    public <R> @Nullable Expression<? extends R> getConvertedExpression(Class<R> ... to) {
        if (CollectionUtils.containsSuperclass(to, this.getReturnType())) {
            return this;
        }
        return this.getConvertedExpr(to);
    }

    @Override
    public @Nullable Class<?>[] acceptChange(Changer.ChangeMode mode) {
        Changer<?> c;
        ClassInfo<Object> rti = this.returnTypeInfo;
        if (rti == null) {
            rti = Classes.getSuperClassInfo(this.getReturnType());
            this.returnTypeInfo = rti;
        }
        if ((c = rti.getChanger()) == null) {
            return null;
        }
        return c.acceptChange(mode);
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        ClassInfo<?> rti = this.returnTypeInfo;
        if (rti == null) {
            throw new UnsupportedOperationException();
        }
        Changer<?> c = rti.getChanger();
        if (c == null) {
            throw new UnsupportedOperationException();
        }
        c.change(this.getArray(e), delta, mode);
    }

    @Override
    public boolean setTime(int time) {
        if (this.getParser().getHasDelayBefore() == Kleenean.TRUE && time != 0) {
            Skript.error("Can't use time states after the event has already passed.");
            return false;
        }
        this.time = time;
        return false;
    }

    protected final boolean setTime(int time, Class<? extends Event> applicableEvent) {
        if (this.getParser().getHasDelayBefore() == Kleenean.TRUE && time != 0) {
            Skript.error("Can't use time states after the event has already passed.");
            return false;
        }
        if (!this.getParser().isCurrentEvent(applicableEvent)) {
            return false;
        }
        this.time = time;
        return true;
    }

    @SafeVarargs
    protected final boolean setTime(int time, Class<? extends Event> ... applicableEvents) {
        if (this.getParser().getHasDelayBefore() == Kleenean.TRUE && time != 0) {
            Skript.error("Can't use time states after the event has already passed.");
            return false;
        }
        if (!this.getParser().isCurrentEvent(applicableEvents)) {
            return false;
        }
        this.time = time;
        return true;
    }

    protected final boolean setTime(int time, Class<? extends Event> applicableEvent, Expression<?> ... mustbeDefaultVars) {
        if (this.getParser().getHasDelayBefore() == Kleenean.TRUE && time != 0) {
            Skript.error("Can't use time states after the event has already passed.");
            return false;
        }
        if (!this.getParser().isCurrentEvent(applicableEvent)) {
            return false;
        }
        for (Expression<?> var : mustbeDefaultVars) {
            if (var.isDefault()) continue;
            return false;
        }
        this.time = time;
        return true;
    }

    @SafeVarargs
    protected final boolean setTime(int time, Expression<?> mustbeDefaultVar, Class<? extends Event> ... applicableEvents) {
        if (this.getParser().getHasDelayBefore() == Kleenean.TRUE && time != 0) {
            Skript.error("Can't use time states after the event has already passed.");
            return false;
        }
        if (mustbeDefaultVar == null) {
            Skript.exception((Throwable)new SkriptAPIException("Default expression was null. If the default expression can be null, don't be using 'SimpleExpression#setTime(int, Expression<?>, Class<? extends Event>...)' instead use the setTime without an expression if null."), new String[0]);
            return false;
        }
        if (!mustbeDefaultVar.isDefault()) {
            return false;
        }
        if (this.getParser().isCurrentEvent(applicableEvents)) {
            this.time = time;
            return true;
        }
        return false;
    }

    @Override
    public int getTime() {
        return this.time;
    }

    @Override
    public boolean isDefault() {
        return false;
    }

    @Override
    public boolean isLoopOf(String s) {
        return false;
    }

    @Override
    public @Nullable Iterator<? extends T> iterator(Event e) {
        return new ArrayIterator<T>(this.getArray(e));
    }

    @Override
    public String toString() {
        return this.toString(null, false);
    }

    @Override
    public Expression<?> getSource() {
        return this;
    }

    @Override
    public Expression<? extends T> simplify() {
        return this;
    }

    @Override
    public boolean getAnd() {
        return true;
    }
}

