/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.sections;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.config.Node;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.events.bukkit.SkriptParseEvent;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Section;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.lang.parser.ParserInstance;
import ch.njol.skript.patterns.PatternCompiler;
import ch.njol.skript.patterns.SkriptPattern;
import ch.njol.skript.util.Patterns;
import ch.njol.util.Kleenean;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;
import org.skriptlang.skript.lang.structure.Structure;

@Name(value="Conditionals")
@Description(value={"Conditional sections", "if: executed when its condition is true", "else if: executed if all previous chained conditionals weren't executed, and its condition is true", "else: executed if all previous chained conditionals weren't executed", "", "parse if: a special case of 'if' condition that its code will not be parsed if the condition is not true", "else parse if: another special case of 'else if' condition that its code will not be parsed if all previous chained conditionals weren't executed, and its condition is true"})
@Examples(value={"if player's health is greater than or equal to 4:", "\tsend \"Your health is okay so far but be careful!\"", "", "else if player's health is greater than 2:", "\tsend \"You need to heal ASAP, your health is very low!\"", "", "else: # Less than 2 hearts", "\tsend \"You are about to DIE if you don't heal NOW. You have only %player's health% heart(s)!\"", "", "parse if plugin \"SomePluginName\" is enabled: # parse if %condition%", "\t# This code will only be executed if the condition used is met otherwise Skript will not parse this section therefore will not give any errors/info about this section", ""})
@Since(value="1.0")
public class SecConditional
extends Section {
    private static final SkriptPattern THEN_PATTERN = PatternCompiler.compile("then [run]");
    private static final Patterns<ConditionalType> CONDITIONAL_PATTERNS = new Patterns(new Object[][]{{"else", ConditionalType.ELSE}, {"else [:parse] if <.+>", ConditionalType.ELSE_IF}, {"else [:parse] if (:any|any:at least one [of])", ConditionalType.ELSE_IF}, {"else [:parse] if [all]", ConditionalType.ELSE_IF}, {"[:parse] if (:any|any:at least one [of])", ConditionalType.IF}, {"[:parse] if [all]", ConditionalType.IF}, {"[:parse] if <.+>", ConditionalType.IF}, {THEN_PATTERN.toString(), ConditionalType.THEN}, {"implicit:<.+>", ConditionalType.IF}});
    private ConditionalType type;
    private List<Condition> conditions = new ArrayList<Condition>();
    private boolean ifAny;
    private boolean parseIf;
    private boolean parseIfPassed;
    private boolean multiline;
    private Kleenean hasDelayAfter;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult, SectionNode sectionNode, List<TriggerItem> triggerItems) {
        this.type = CONDITIONAL_PATTERNS.getInfo(matchedPattern);
        this.ifAny = parseResult.hasTag("any");
        this.parseIf = parseResult.hasTag("parse");
        boolean bl = this.multiline = parseResult.regexes.size() == 0 && this.type != ConditionalType.ELSE;
        if (this.type != ConditionalType.IF) {
            if (this.type == ConditionalType.THEN) {
                SecConditional precedingConditional = SecConditional.getPrecedingConditional(triggerItems, null);
                if (precedingConditional == null || !precedingConditional.multiline) {
                    Skript.error("'then' has to placed just after a multiline 'if' or 'else if' section");
                    return false;
                }
            } else {
                SecConditional precedingIf = SecConditional.getPrecedingConditional(triggerItems, ConditionalType.IF);
                if (precedingIf == null) {
                    if (this.type == ConditionalType.ELSE_IF) {
                        Skript.error("'else if' has to be placed just after another 'if' or 'else if' section");
                    } else if (this.type == ConditionalType.ELSE) {
                        Skript.error("'else' has to be placed just after another 'if' or 'else if' section");
                    } else if (this.type == ConditionalType.THEN) {
                        Skript.error("'then' has to placed just after a multiline 'if' or 'else if' section");
                    }
                    return false;
                }
            }
        } else if (this.multiline) {
            Node nextNode = this.getNextNode(sectionNode, this.getParser());
            String error = (this.ifAny ? "'if any'" : "'if all'") + " has to be placed just before a 'then' section";
            if (nextNode instanceof SectionNode && nextNode.getKey() != null) {
                String nextNodeKey = ScriptLoader.replaceOptions(nextNode.getKey());
                if (THEN_PATTERN.match(nextNodeKey) == null) {
                    Skript.error(error);
                    return false;
                }
            } else {
                Skript.error(error);
                return false;
            }
        }
        if (this.type == ConditionalType.IF || this.type == ConditionalType.ELSE_IF) {
            ParserInstance parser = this.getParser();
            Class<? extends Event>[] currentEvents = parser.getCurrentEvents();
            String currentEventName = parser.getCurrentEventName();
            Structure currentStructure = parser.getCurrentStructure();
            if (this.parseIf) {
                parser.setCurrentEvents(new Class[]{SkriptParseEvent.class});
                parser.setCurrentEventName("parse");
                parser.setCurrentStructure(null);
            }
            if (this.multiline) {
                int nonEmptyNodeCount = Iterables.size((Iterable)sectionNode);
                if (nonEmptyNodeCount < 2) {
                    Skript.error((this.ifAny ? "'if any'" : "'if all'") + " sections must contain at least two conditions");
                    return false;
                }
                for (Node childNode : sectionNode) {
                    if (childNode instanceof SectionNode) {
                        Skript.error((this.ifAny ? "'if any'" : "'if all'") + " sections may not contain other sections");
                        return false;
                    }
                    String childKey = childNode.getKey();
                    if (childKey == null) continue;
                    childKey = ScriptLoader.replaceOptions(childKey);
                    parser.setNode(childNode);
                    Condition condition = Condition.parse(childKey, "Can't understand this condition: '" + childKey + "'");
                    if (condition == null) {
                        return false;
                    }
                    this.conditions.add(condition);
                }
                parser.setNode(sectionNode);
            } else {
                String expr = parseResult.regexes.get(0).group();
                Condition condition = Condition.parse(expr, parseResult.hasTag("implicit") ? null : "Can't understand this condition: '" + expr + "'");
                if (condition != null) {
                    this.conditions.add(condition);
                }
            }
            if (this.parseIf) {
                parser.setCurrentEvents(currentEvents);
                parser.setCurrentEventName(currentEventName);
                parser.setCurrentStructure(currentStructure);
            }
            if (this.conditions.isEmpty()) {
                return false;
            }
        }
        if (this.parseIf) {
            if (!this.checkConditions(new SkriptParseEvent())) {
                return true;
            }
            this.parseIfPassed = true;
        }
        Kleenean hadDelayBefore = this.getParser().getHasDelayBefore();
        if (!this.multiline || this.type == ConditionalType.THEN) {
            this.loadCode(sectionNode);
        }
        this.hasDelayAfter = this.getParser().getHasDelayBefore();
        if (hadDelayBefore.isTrue() || hadDelayBefore.equals((Object)this.hasDelayAfter)) {
            return true;
        }
        if (this.type == ConditionalType.ELSE) {
            SecConditional precedingIf = SecConditional.getPrecedingConditional(triggerItems, ConditionalType.IF);
            assert (precedingIf != null);
            if (this.hasDelayAfter.isTrue() && precedingIf.hasDelayAfter.isTrue() && SecConditional.getElseIfs(triggerItems).stream().map(SecConditional::getHasDelayAfter).allMatch(Kleenean::isTrue)) {
                this.getParser().setHasDelayBefore(Kleenean.TRUE);
            } else {
                this.getParser().setHasDelayBefore(Kleenean.UNKNOWN);
            }
        } else if (!this.hasDelayAfter.isFalse()) {
            this.getParser().setHasDelayBefore(Kleenean.UNKNOWN);
        }
        return true;
    }

    @Override
    public @Nullable TriggerItem getNext() {
        return this.getSkippedNext();
    }

    public @Nullable TriggerItem getNormalNext() {
        return super.getNext();
    }

    @Override
    protected @Nullable TriggerItem walk(Event event) {
        if (this.type == ConditionalType.THEN || this.parseIf && !this.parseIfPassed) {
            return this.getNormalNext();
        }
        if (this.parseIf || this.checkConditions(event)) {
            SecConditional sectionToRun = this.multiline ? (SecConditional)this.getNormalNext() : this;
            TriggerItem skippedNext = this.getSkippedNext();
            if (sectionToRun.last != null) {
                sectionToRun.last.setNext(skippedNext);
            }
            return sectionToRun.first != null ? sectionToRun.first : skippedNext;
        }
        return this.getNormalNext();
    }

    private @Nullable TriggerItem getSkippedNext() {
        TriggerItem next = this.getNormalNext();
        while (next instanceof SecConditional && ((SecConditional)next).type != ConditionalType.IF) {
            next = ((SecConditional)next).getNormalNext();
        }
        return next;
    }

    @Override
    public String toString(@Nullable Event event, boolean debug) {
        String parseIf = this.parseIf ? "parse " : "";
        switch (this.type) {
            case IF: {
                if (this.multiline) {
                    return parseIf + "if " + (this.ifAny ? "any" : "all");
                }
                return parseIf + "if " + this.conditions.get(0).toString(event, debug);
            }
            case ELSE_IF: {
                if (this.multiline) {
                    return "else " + parseIf + "if " + (this.ifAny ? "any" : "all");
                }
                return "else " + parseIf + "if " + this.conditions.get(0).toString(event, debug);
            }
            case ELSE: {
                return "else";
            }
            case THEN: {
                return "then";
            }
        }
        throw new IllegalStateException();
    }

    private Kleenean getHasDelayAfter() {
        return this.hasDelayAfter;
    }

    private static @Nullable SecConditional getPrecedingConditional(List<TriggerItem> triggerItems, @Nullable ConditionalType type) {
        for (int i = triggerItems.size() - 1; i >= 0; --i) {
            TriggerItem triggerItem = triggerItems.get(i);
            if (triggerItem instanceof SecConditional) {
                SecConditional conditionalSection = (SecConditional)triggerItem;
                if (conditionalSection.type == ConditionalType.ELSE) {
                    return null;
                }
                if (type != null && conditionalSection.type != type) continue;
                return conditionalSection;
            }
            return null;
        }
        return null;
    }

    private static List<SecConditional> getElseIfs(List<TriggerItem> triggerItems) {
        TriggerItem triggerItem;
        ArrayList<SecConditional> list = new ArrayList<SecConditional>();
        for (int i = triggerItems.size() - 1; i >= 0 && (triggerItem = triggerItems.get(i)) instanceof SecConditional; --i) {
            SecConditional secConditional = (SecConditional)triggerItem;
            if (secConditional.type != ConditionalType.ELSE_IF) break;
            list.add(secConditional);
        }
        return list;
    }

    private boolean checkConditions(Event event) {
        if (this.conditions.isEmpty()) {
            return true;
        }
        if (this.ifAny) {
            return this.conditions.stream().anyMatch(c -> c.check(event));
        }
        return this.conditions.stream().allMatch(c -> c.check(event));
    }

    private @Nullable Node getNextNode(Node precedingNode, ParserInstance parser) {
        Node originalCurrentNode = parser.getNode();
        SectionNode parentNode = precedingNode.getParent();
        if (parentNode == null) {
            return null;
        }
        Iterator<Node> parentIterator = parentNode.iterator();
        while (parentIterator.hasNext()) {
            Node current = parentIterator.next();
            if (current != precedingNode) continue;
            Node nextNode = parentIterator.hasNext() ? parentIterator.next() : null;
            parser.setNode(originalCurrentNode);
            return nextNode;
        }
        parser.setNode(originalCurrentNode);
        return null;
    }

    static {
        Skript.registerSection(SecConditional.class, CONDITIONAL_PATTERNS.getPatterns());
    }

    private static enum ConditionalType {
        ELSE,
        ELSE_IF,
        IF,
        THEN;

    }
}

