/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.structures;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.function.FunctionEvent;
import ch.njol.skript.lang.function.Functions;
import ch.njol.skript.lang.function.Signature;
import ch.njol.skript.lang.parser.ParserInstance;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.MatchResult;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;
import org.skriptlang.skript.lang.entry.EntryContainer;
import org.skriptlang.skript.lang.structure.Structure;

@Name(value="Function")
@Description(value={"Functions are structures that can be executed with arguments/parameters to run code.", "They can also return a value to the trigger that is executing the function.", "Note that local functions come before global functions execution"})
@Examples(value={"function sayMessage(message: text):", "\tbroadcast {_message} # our message argument is available in '{_message}'", "", "local function giveApple(amount: number) :: item:", "\treturn {_amount} of apple"})
@Since(value="2.2, 2.7 (local functions)")
public class StructFunction
extends Structure {
    public static final Structure.Priority PRIORITY = new Structure.Priority(400);
    private static final AtomicBoolean VALIDATE_FUNCTIONS = new AtomicBoolean();
    private Signature<?> signature;
    private boolean local;

    @Override
    public boolean init(Literal<?>[] literals, int matchedPattern, SkriptParser.ParseResult parseResult, EntryContainer entryContainer) {
        this.local = parseResult.hasTag("local");
        MatchResult regex = parseResult.regexes.get(0);
        String name = regex.group(1);
        String args = regex.group(2);
        String returnType = regex.group(3);
        this.getParser().setCurrentEvent((this.local ? "local " : "") + "function", FunctionEvent.class);
        this.signature = Functions.parseSignature(this.getParser().getCurrentScript().getConfig().getFileName(), name, args, returnType, this.local);
        this.getParser().deleteCurrentEvent();
        return this.signature != null;
    }

    @Override
    public boolean preLoad() {
        return Functions.registerSignature(this.signature) != null;
    }

    @Override
    public boolean load() {
        ParserInstance parser = this.getParser();
        parser.setCurrentEvent((this.local ? "local " : "") + "function", FunctionEvent.class);
        Functions.loadFunction(parser.getCurrentScript(), this.getEntryContainer().getSource(), this.signature);
        parser.deleteCurrentEvent();
        VALIDATE_FUNCTIONS.set(true);
        return true;
    }

    @Override
    public boolean postLoad() {
        if (VALIDATE_FUNCTIONS.get()) {
            VALIDATE_FUNCTIONS.set(false);
            Functions.validateFunctions();
        }
        return true;
    }

    @Override
    public void unload() {
        Functions.unregisterFunction(this.signature);
        VALIDATE_FUNCTIONS.set(true);
    }

    @Override
    public Structure.Priority getPriority() {
        return PRIORITY;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return (this.local ? "local " : "") + "function";
    }

    static {
        Skript.registerStructure(StructFunction.class, "[:local] function <([\\p{IsAlphabetic}][\\p{IsAlphabetic}\\p{IsDigit}_]*)\\((.*)\\)(?:\\s*::\\s*(.+))?>");
    }
}

