/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.test.runner;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.registrations.EventValues;
import ch.njol.skript.test.runner.SkriptJUnitTest;
import ch.njol.skript.test.runner.SkriptTestEvent;
import ch.njol.skript.test.runner.TestMode;
import ch.njol.skript.test.runner.TestTracker;
import ch.njol.skript.util.Getter;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

public class EvtTestCase
extends SkriptEvent {
    private Expression<String> name;
    private @Nullable Condition condition;

    @Override
    public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parseResult) {
        this.name = args[0];
        if (!parseResult.regexes.isEmpty()) {
            String cond = parseResult.regexes.get(0).group();
            this.condition = Condition.parse(cond, "Can't understand this condition: " + cond);
        }
        return true;
    }

    @Override
    public boolean check(Event event) {
        String n = this.name.getSingle(event);
        if (n == null) {
            return false;
        }
        Skript.info("Running test case " + n);
        TestTracker.testStarted(n);
        return true;
    }

    @Override
    public boolean shouldLoadEvent() {
        return this.condition != null ? this.condition.check(new SkriptTestEvent()) : true;
    }

    @Override
    public String toString(@Nullable Event event, boolean debug) {
        if (event != null) {
            return "test " + this.name.getSingle(event);
        }
        return "test case";
    }

    static {
        if (TestMode.ENABLED) {
            Skript.registerEvent("Test Case", EvtTestCase.class, SkriptTestEvent.class, "test %string% [when <.+>]").description("Contents represent one test case.").examples("").since("2.5");
            EventValues.registerEventValue(SkriptTestEvent.class, Block.class, new Getter<Block, SkriptTestEvent>(){

                @Override
                public @Nullable Block get(SkriptTestEvent ignored) {
                    return SkriptJUnitTest.getBlock();
                }
            }, 0);
            EventValues.registerEventValue(SkriptTestEvent.class, Location.class, new Getter<Location, SkriptTestEvent>(){

                @Override
                public @Nullable Location get(SkriptTestEvent ignored) {
                    return SkriptJUnitTest.getTestLocation();
                }
            }, 0);
        }
    }
}

