/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.util;

import java.util.Arrays;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class Math2 {
    private Math2() {
    }

    public static int fit(int min, int value, int max) {
        assert (min <= max) : min + "," + value + "," + max;
        return Math.min(Math.max(value, min), max);
    }

    public static long fit(long min, long value, long max) {
        assert (min <= max) : min + "," + value + "," + max;
        return Math.min(Math.max(value, min), max);
    }

    public static float fit(float min, float value, float max) {
        assert (min <= max) : min + "," + value + "," + max;
        return Math.min(Math.max(value, min), max);
    }

    public static double fit(double min, double value, double max) {
        assert (min <= max) : min + "," + value + "," + max;
        return Math.min(Math.max(value, min), max);
    }

    public static int mod(int value, int mod) {
        return (value % mod + mod) % mod;
    }

    public static long mod(long value, long mod) {
        return (value % mod + mod) % mod;
    }

    public static float mod(float value, float mod) {
        return (value % mod + mod) % mod;
    }

    public static double mod(double value, double mod) {
        return (value % mod + mod) % mod;
    }

    public static int ceil(float value) {
        return (int)Math.ceil((double)value - 1.0E-10);
    }

    public static int round(float value) {
        return (int)Math.round((double)value + 1.0E-10);
    }

    public static long floor(double value) {
        return (long)Math.floor(value + 1.0E-10);
    }

    public static long ceil(double value) {
        return (long)Math.ceil(value - 1.0E-10);
    }

    public static long round(double value) {
        return Math.round(value + 1.0E-10);
    }

    public static float safe(float value) {
        return Float.isFinite(value) ? value : 0.0f;
    }

    @Deprecated
    public static int floorI(double value) {
        return (int)Math.floor(value + 1.0E-10);
    }

    @Deprecated
    public static int ceilI(double value) {
        return (int)Math.ceil(value - 1.0E-10);
    }

    @Deprecated
    public static long floor(float value) {
        return (long)Math.floor((double)value + 1.0E-10);
    }

    @Deprecated
    public static int min(int a, int b, int c) {
        return Math.min(a, Math.min(b, c));
    }

    @Deprecated
    public static int min(int ... numbers) {
        if (numbers.length == 0) {
            return 0;
        }
        return Arrays.stream(numbers).min().getAsInt();
    }

    @Deprecated
    public static int max(int a, int b, int c) {
        return Math.max(a, Math.max(b, c));
    }

    @Deprecated
    public static int max(int ... numbers) {
        if (numbers.length == 0) {
            return 0;
        }
        return Arrays.stream(numbers).max().getAsInt();
    }

    @Deprecated
    public static double min(double a, double b, double c) {
        return Math.min(a, Math.min(b, c));
    }

    @Deprecated
    public static double min(double ... numbers) {
        if (numbers.length == 0) {
            return Double.NaN;
        }
        return Arrays.stream(numbers).min().getAsDouble();
    }

    @Deprecated
    public static double max(double a, double b, double c) {
        return Math.max(a, Math.max(b, c));
    }

    @Deprecated
    public static double max(double ... numbers) {
        if (numbers.length == 0) {
            return Double.NaN;
        }
        return Arrays.stream(numbers).max().getAsDouble();
    }
}

