/*
 * Decompiled with CFR 0.152.
 */
package org.skriptlang.skript.lang.comparator;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAPIException;
import ch.njol.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.skriptlang.skript.lang.comparator.Comparator;
import org.skriptlang.skript.lang.comparator.ComparatorInfo;
import org.skriptlang.skript.lang.comparator.ConvertedComparator;
import org.skriptlang.skript.lang.comparator.InverseComparator;
import org.skriptlang.skript.lang.comparator.Relation;
import org.skriptlang.skript.lang.converter.Converter;
import org.skriptlang.skript.lang.converter.Converters;

public final class Comparators {
    private static final ComparatorInfo<Object, Object> EQUALS_COMPARATOR_INFO = new ComparatorInfo<Object, Object>(Object.class, Object.class, (o1, o2) -> Relation.get(o1.equals(o2)));
    private static final List<ComparatorInfo<?, ?>> COMPARATORS = new ArrayList(50);
    private static final Map<Pair<Class<?>, Class<?>>, ComparatorInfo<?, ?>> QUICK_ACCESS_COMPARATORS = new HashMap(50);

    private Comparators() {
    }

    public static @Unmodifiable List<ComparatorInfo<?, ?>> getComparatorInfos() {
        Comparators.assertIsDoneLoading();
        return Collections.unmodifiableList(COMPARATORS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T1, T2> void registerComparator(Class<T1> firstType, Class<T2> secondType, Comparator<T1, T2> comparator) {
        Skript.checkAcceptRegistrations();
        if (firstType == Object.class && secondType == Object.class) {
            throw new IllegalArgumentException("It is not possible to add a comparator between objects");
        }
        List<ComparatorInfo<?, ?>> list = COMPARATORS;
        synchronized (list) {
            for (ComparatorInfo<?, ?> info : COMPARATORS) {
                if (info.firstType != firstType || info.secondType != secondType) continue;
                throw new SkriptAPIException("A Comparator comparing '" + firstType + "' and '" + secondType + "' already exists!");
            }
            COMPARATORS.add(new ComparatorInfo<T1, T2>(firstType, secondType, comparator));
        }
    }

    public static <T1, T2> Relation compare(@Nullable T1 first, @Nullable T2 second) {
        Comparators.assertIsDoneLoading();
        if (first == null || second == null) {
            return Relation.NOT_EQUAL;
        }
        if (first == second) {
            return Relation.EQUAL;
        }
        Comparator<?, ?> comparator = Comparators.getComparator(first.getClass(), second.getClass());
        if (comparator == null) {
            return Relation.NOT_EQUAL;
        }
        return comparator.compare(first, second);
    }

    public static <T1, T2> @Nullable Comparator<T1, T2> getComparator(Class<T1> firstType, Class<T2> secondType) {
        ComparatorInfo<T1, T2> info = Comparators.getComparatorInfo(firstType, secondType);
        return info != null ? info.comparator : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T1, T2> @Nullable ComparatorInfo<T1, T2> getComparatorInfo(Class<T1> firstType, Class<T2> secondType) {
        ComparatorInfo<Object, Object> comparator;
        Comparators.assertIsDoneLoading();
        Pair<Class<T1>, Class<T2>> pair = new Pair<Class<T1>, Class<T2>>(firstType, secondType);
        Map<Pair<Class<?>, Class<?>>, ComparatorInfo<?, ?>> map = QUICK_ACCESS_COMPARATORS;
        synchronized (map) {
            if (QUICK_ACCESS_COMPARATORS.containsKey(pair)) {
                comparator = QUICK_ACCESS_COMPARATORS.get(pair);
            } else {
                comparator = Comparators.getComparatorInfo_i(firstType, secondType);
                QUICK_ACCESS_COMPARATORS.put(pair, comparator);
            }
        }
        return comparator;
    }

    private static <T1, T2, C1, C2> @Nullable ComparatorInfo<T1, T2> getComparatorInfo_i(Class<T1> firstType, Class<T2> secondType) {
        Converter<T2, Object> c2;
        Converter<T1, Object> c1;
        ComparatorInfo<?, ?> info;
        ComparatorInfo<?, ?> unknownInfo2;
        for (ComparatorInfo<?, ?> info2 : COMPARATORS) {
            if (info2.firstType != firstType || info2.secondType != secondType) continue;
            return info2;
        }
        for (ComparatorInfo<?, ?> info2 : COMPARATORS) {
            if (!info2.firstType.isAssignableFrom(firstType) || !info2.secondType.isAssignableFrom(secondType)) continue;
            return info2;
        }
        for (ComparatorInfo<?, ?> info2 : COMPARATORS) {
            if (!info2.comparator.supportsInversion() || !info2.firstType.isAssignableFrom(secondType) || !info2.secondType.isAssignableFrom(firstType)) continue;
            return new ComparatorInfo<T1, T2>(firstType, secondType, new InverseComparator(info2.comparator));
        }
        Iterator<ComparatorInfo<?, ?>> iterator = COMPARATORS.iterator();
        while (iterator.hasNext()) {
            Converter fc1;
            Converter sc2;
            info = unknownInfo2 = iterator.next();
            if (info.firstType.isAssignableFrom(firstType) && (sc2 = Converters.getConverter(secondType, info.secondType)) != null) {
                return new ComparatorInfo<T1, T2>(firstType, secondType, new ConvertedComparator(null, info.comparator, sc2));
            }
            if (!info.secondType.isAssignableFrom(secondType) || (fc1 = Converters.getConverter(firstType, info.firstType)) == null) continue;
            return new ComparatorInfo<T1, T2>(firstType, secondType, new ConvertedComparator(fc1, info.comparator, null));
        }
        for (ComparatorInfo<?, ?> unknownInfo2 : COMPARATORS) {
            Converter fc2;
            Converter sc1;
            if (!unknownInfo2.comparator.supportsInversion()) continue;
            info = unknownInfo2;
            if (info.secondType.isAssignableFrom(firstType) && (sc1 = Converters.getConverter(secondType, info.firstType)) != null) {
                return new ComparatorInfo<T1, T2>(firstType, secondType, new InverseComparator(new ConvertedComparator(sc1, info.comparator, null)));
            }
            if (!info.firstType.isAssignableFrom(secondType) || (fc2 = Converters.getConverter(firstType, info.secondType)) == null) continue;
            return new ComparatorInfo<T1, T2>(firstType, secondType, new InverseComparator(new ConvertedComparator(null, info.comparator, fc2)));
        }
        iterator = COMPARATORS.iterator();
        while (iterator.hasNext()) {
            info = unknownInfo2 = iterator.next();
            c1 = Converters.getConverter(firstType, info.firstType);
            c2 = Converters.getConverter(secondType, info.secondType);
            if (c1 == null || c2 == null) continue;
            return new ComparatorInfo<T1, T2>(firstType, secondType, new ConvertedComparator(c1, info.comparator, c2));
        }
        for (ComparatorInfo<?, ?> unknownInfo2 : COMPARATORS) {
            if (!unknownInfo2.comparator.supportsInversion()) continue;
            info = unknownInfo2;
            c1 = Converters.getConverter(firstType, info.secondType);
            c2 = Converters.getConverter(secondType, info.firstType);
            if (c1 == null || c2 == null) continue;
            return new ComparatorInfo<T1, T2>(firstType, secondType, new InverseComparator(new ConvertedComparator(c2, info.comparator, c1)));
        }
        if (firstType != Object.class && secondType == firstType) {
            return EQUALS_COMPARATOR_INFO;
        }
        return null;
    }

    private static void assertIsDoneLoading() {
        if (Skript.isAcceptRegistrations()) {
            throw new SkriptAPIException("Comparators cannot be retrieved until Skript has finished registrations.");
        }
    }
}

