/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.classes;

import ch.njol.skript.lang.Expression;
import org.eclipse.jdt.annotation.Nullable;

public interface Changer<T> {
    public @Nullable Class<?>[] acceptChange(ChangeMode var1);

    public void change(T[] var1, @Nullable Object[] var2, ChangeMode var3);

    public static abstract class ChangerUtils {
        public static <T, V> void change(Changer<T> changer, Object[] what, @Nullable Object[] delta, ChangeMode mode) {
            changer.change(what, delta, mode);
        }

        public static boolean acceptsChange(Expression<?> e, ChangeMode mode, Class<?> ... types) {
            Class<?>[] cs = e.acceptChange(mode);
            if (cs == null) {
                return false;
            }
            for (Class<?> type : types) {
                for (Class<?> c : cs) {
                    if (!(c.isArray() ? c.getComponentType().isAssignableFrom(type) : c.isAssignableFrom(type))) continue;
                    return true;
                }
            }
            return false;
        }
    }

    public static enum ChangeMode {
        ADD,
        SET,
        REMOVE,
        REMOVE_ALL,
        DELETE,
        RESET;

    }
}

