/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.classes.data;

import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.entity.EntityType;
import ch.njol.skript.entity.XpOrbData;
import ch.njol.skript.util.BlockInventoryHolder;
import ch.njol.skript.util.BlockUtils;
import ch.njol.skript.util.Direction;
import ch.njol.skript.util.EnchantmentType;
import ch.njol.skript.util.Experience;
import ch.njol.skript.util.slot.Slot;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.DoubleChest;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.enchantments.EnchantmentOffer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.util.Vector;
import org.skriptlang.skript.lang.converter.Converters;

public class DefaultConverters {
    static {
        Converters.registerConverter(Number.class, Byte.class, Number::byteValue);
        Converters.registerConverter(Number.class, Double.class, Number::doubleValue);
        Converters.registerConverter(Number.class, Float.class, Number::floatValue);
        Converters.registerConverter(Number.class, Integer.class, Number::intValue);
        Converters.registerConverter(Number.class, Long.class, Number::longValue);
        Converters.registerConverter(Number.class, Short.class, Number::shortValue);
        Converters.registerConverter(OfflinePlayer.class, PlayerInventory.class, p -> {
            if (!p.isOnline()) {
                return null;
            }
            Player online = p.getPlayer();
            assert (online != null);
            return online.getInventory();
        }, 4);
        Converters.registerConverter(OfflinePlayer.class, Player.class, OfflinePlayer::getPlayer, 4);
        Converters.registerConverter(CommandSender.class, Player.class, s -> {
            if (s instanceof Player) {
                return (Player)s;
            }
            return null;
        });
        Converters.registerConverter(BlockCommandSender.class, Block.class, BlockCommandSender::getBlock);
        Converters.registerConverter(Entity.class, Player.class, e -> {
            if (e instanceof Player) {
                return (Player)e;
            }
            return null;
        });
        Converters.registerConverter(Entity.class, LivingEntity.class, e -> {
            if (e instanceof LivingEntity) {
                return (LivingEntity)e;
            }
            return null;
        });
        Converters.registerConverter(Block.class, Inventory.class, b -> {
            if (b.getState() instanceof InventoryHolder) {
                return ((InventoryHolder)b.getState()).getInventory();
            }
            return null;
        }, 4);
        Converters.registerConverter(Entity.class, Inventory.class, e -> {
            if (e instanceof InventoryHolder) {
                return ((InventoryHolder)e).getInventory();
            }
            return null;
        }, 4);
        Converters.registerConverter(Block.class, ItemType.class, ItemType::new, 5);
        Converters.registerConverter(Block.class, Location.class, BlockUtils::getLocation, 4);
        Converters.registerConverter(Entity.class, Location.class, Entity::getLocation, 4);
        Converters.registerConverter(Entity.class, EntityData.class, EntityData::fromEntity, 6);
        Converters.registerConverter(EntityData.class, EntityType.class, data -> new EntityType((EntityData<?>)data, -1));
        Converters.registerConverter(ItemType.class, ItemStack.class, ItemType::getRandom);
        Converters.registerConverter(ItemStack.class, ItemType.class, ItemType::new);
        Converters.registerConverter(Experience.class, XpOrbData.class, e -> new XpOrbData(e.getXP()));
        Converters.registerConverter(XpOrbData.class, Experience.class, e -> new Experience(e.getExperience()));
        Converters.registerConverter(Slot.class, ItemType.class, s -> {
            ItemStack i = s.getItem();
            return new ItemType(i != null ? i : new ItemStack(Material.AIR, 1));
        });
        Converters.registerConverter(Block.class, InventoryHolder.class, b -> {
            BlockState s = b.getState();
            if (s instanceof InventoryHolder) {
                return (InventoryHolder)s;
            }
            return null;
        }, 6);
        Converters.registerConverter(InventoryHolder.class, Block.class, holder -> {
            if (holder instanceof BlockState) {
                return new BlockInventoryHolder((BlockState)holder);
            }
            if (holder instanceof DoubleChest) {
                return holder.getInventory().getLocation().getBlock();
            }
            return null;
        });
        Converters.registerConverter(InventoryHolder.class, Entity.class, holder -> {
            if (holder instanceof Entity) {
                return (Entity)holder;
            }
            return null;
        });
        Converters.registerConverter(Enchantment.class, EnchantmentType.class, e -> new EnchantmentType((Enchantment)e, -1));
        Converters.registerConverter(Vector.class, Direction.class, Direction::new);
        Converters.registerConverter(EnchantmentOffer.class, EnchantmentType.class, eo -> new EnchantmentType(eo.getEnchantment(), eo.getEnchantmentLevel()));
        Converters.registerConverter(String.class, World.class, Bukkit::getWorld);
        Converters.registerConverter(Location.class, Chunk.class, Location::getChunk);
    }
}

