/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Can See")
@Description(value={"Checks whether the given players can see another players."})
@Examples(value={"if the player can't see the player-argument:", "\tmessage \"&lt;light red&gt;The player %player-argument% is not online!\""})
@Since(value="2.3")
public class CondCanSee
extends Condition {
    private Expression<Player> players;
    private Expression<Player> targetPlayers;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (matchedPattern == 1 || matchedPattern == 3) {
            this.players = exprs[0];
            this.targetPlayers = exprs[1];
        } else {
            this.players = exprs[1];
            this.targetPlayers = exprs[0];
        }
        this.setNegated(matchedPattern > 1 ^ parseResult.mark == 1);
        return true;
    }

    @Override
    public boolean check(Event e) {
        return this.players.check(e, player -> this.targetPlayers.check(e, arg_0 -> ((Player)player).canSee(arg_0)), this.isNegated());
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return PropertyCondition.toString(this, PropertyCondition.PropertyType.CAN, e, debug, this.players, "see" + this.targetPlayers.toString(e, debug));
    }

    static {
        Skript.registerCondition(CondCanSee.class, "%players% (is|are) [(1\u00a6in)]visible for %players%", "%players% can see %players%", "%players% (is|are)(n't| not) [(1\u00a6in)]visible for %players%", "%players% can('t| not) see %players%");
    }
}

