/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.util.slot.Slot;
import org.bukkit.Material;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

@Name(value="Is Empty")
@Description(value={"Checks whether an inventory, an inventory slot, or a text is empty."})
@Examples(value={"player's inventory is empty"})
@Since(value="<i>unknown</i> (before 2.1)")
public class CondIsEmpty
extends PropertyCondition<Object> {
    @Override
    public boolean check(Object o) {
        if (o instanceof String) {
            return ((String)o).isEmpty();
        }
        if (o instanceof Inventory) {
            for (ItemStack s : ((Inventory)o).getContents()) {
                if (s == null || s.getType() == Material.AIR) continue;
                return false;
            }
            return true;
        }
        if (o instanceof Slot) {
            Slot s = (Slot)o;
            ItemStack i = s.getItem();
            return i == null || i.getType() == Material.AIR;
        }
        assert (false);
        return false;
    }

    @Override
    protected String getPropertyName() {
        return "empty";
    }

    static {
        CondIsEmpty.register(CondIsEmpty.class, "empty", "inventories/slots/strings");
    }
}

