/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import org.bukkit.potion.PotionEffect;

@Name(value="Is Infinite")
@Description(value={"Checks whether potion effects are infinite."})
@Examples(value={"all of the active potion effects of the player are infinite"})
@Since(value="2.7")
public class CondIsInfinite
extends PropertyCondition<PotionEffect> {
    @Override
    public boolean check(PotionEffect potion) {
        return potion.isInfinite();
    }

    @Override
    protected String getPropertyName() {
        return "infinite";
    }

    static {
        if (Skript.methodExists(PotionEffect.class, "isInfinite", new Class[0])) {
            CondIsInfinite.register(CondIsInfinite.class, "infinite", "potioneffects");
        }
    }
}

