/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.lang.TriggerSection;
import ch.njol.skript.lang.parser.ParserInstance;
import ch.njol.skript.sections.SecLoop;
import ch.njol.skript.sections.SecWhile;
import ch.njol.util.Kleenean;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Continue")
@Description(value={"Skips the value currently being looped, moving on to the next value if it exists."})
@Examples(value={"loop all players:", "\tif loop-value does not have permission \"moderator\":", "\t\tcontinue # filter out non moderators", "\tbroadcast \"%loop-player% is a moderator!\" # Only moderators get broadcast"})
@Since(value="2.2-dev37, 2.7 (while loops)")
public class EffContinue
extends Effect {
    private TriggerSection section;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        List currentSections = ParserInstance.get().getCurrentSections().stream().filter(s -> s instanceof SecLoop || s instanceof SecWhile).collect(Collectors.toList());
        if (currentSections.isEmpty()) {
            Skript.error("Continue may only be used in while or loops");
            return false;
        }
        this.section = (TriggerSection)currentSections.get(currentSections.size() - 1);
        return true;
    }

    @Override
    protected void execute(Event e) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected @Nullable TriggerItem walk(Event e) {
        return this.section;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "continue";
    }

    static {
        Skript.registerEffect(EffContinue.class, "continue [loop]");
    }
}

