/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Timespan;
import ch.njol.util.Kleenean;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Poison/Cure")
@Description(value={"Poison or cure a creature."})
@Examples(value={"poison the player", "poison the victim for 20 seconds", "cure the player from poison"})
@Since(value="1.3.2")
public class EffPoison
extends Effect {
    private static final int DEFAULT_DURATION = 300;
    private Expression<LivingEntity> entites;
    private @Nullable Expression<Timespan> duration;
    private boolean cure;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.entites = exprs[0];
        if (matchedPattern == 0) {
            this.duration = exprs[1];
        }
        this.cure = matchedPattern == 1;
        return true;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "poison " + this.entites.toString(e, debug);
    }

    @Override
    protected void execute(Event e) {
        for (LivingEntity le : this.entites.getArray(e)) {
            if (!this.cure) {
                Timespan dur;
                int d = (int)(this.duration != null && (dur = this.duration.getSingle(e)) != null ? (dur.getTicks_i() >= Integer.MAX_VALUE ? Integer.MAX_VALUE : dur.getTicks_i()) : 300L);
                if (le.hasPotionEffect(PotionEffectType.POISON)) {
                    for (PotionEffect pe : le.getActivePotionEffects()) {
                        if (pe.getType() != PotionEffectType.POISON) continue;
                        d += pe.getDuration();
                    }
                }
                le.addPotionEffect(new PotionEffect(PotionEffectType.POISON, d, 0), true);
                continue;
            }
            le.removePotionEffect(PotionEffectType.POISON);
        }
    }

    static {
        Skript.registerEffect(EffPoison.class, "poison %livingentities% [for %-timespan%]", "(cure|unpoison) %livingentities% [(from|of) poison]");
    }
}

