/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.events;

import ch.njol.skript.Skript;
import ch.njol.skript.bukkitutil.ItemUtils;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Checker;
import java.util.Locale;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.Silverfish;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.eclipse.jdt.annotation.Nullable;

public class EvtEntityBlockChange
extends SkriptEvent {
    private ChangeEvent event;

    @Override
    public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parser) {
        this.event = ChangeEvent.values()[matchedPattern];
        return true;
    }

    @Override
    public boolean check(Event event) {
        if (!(event instanceof EntityChangeBlockEvent)) {
            return false;
        }
        return this.event.checker.check((EntityChangeBlockEvent)event);
    }

    @Override
    public String toString(@Nullable Event event, boolean debug) {
        return this.event.name().toLowerCase(Locale.ENGLISH).replace('_', ' ');
    }

    static {
        Skript.registerEvent("Enderman/Sheep/Silverfish/Falling Block", EvtEntityBlockChange.class, EntityChangeBlockEvent.class, ChangeEvent.patterns).description("Called when an enderman places or picks up a block, a sheep eats grass, a silverfish boops into/out of a block or a falling block lands and turns into a block respectively.").examples("on sheep eat:", "\tkill event-entity", "\tbroadcast \"A sheep stole some grass!\"", "", "on falling block land:", "\tevent-entity is a falling dirt", "\tcancel event").since("<i>unknown</i>, 2.5.2 (falling block)");
    }

    private static enum ChangeEvent {
        ENDERMAN_PLACE("enderman place", event -> event.getEntity() instanceof Enderman && !ItemUtils.isAir(event.getTo())),
        ENDERMAN_PICKUP("enderman pickup", event -> event.getEntity() instanceof Enderman && ItemUtils.isAir(event.getTo())),
        SHEEP_EAT("sheep eat", event -> event.getEntity() instanceof Sheep),
        SILVERFISH_ENTER("silverfish enter", event -> event.getEntity() instanceof Silverfish && !ItemUtils.isAir(event.getTo())),
        SILVERFISH_EXIT("silverfish exit", event -> event.getEntity() instanceof Silverfish && ItemUtils.isAir(event.getTo())),
        FALLING_BLOCK_FALLING("falling block fall[ing]", event -> event.getEntity() instanceof FallingBlock && ItemUtils.isAir(event.getTo())),
        FALLING_BLOCK_LANDING("falling block land[ing]", event -> event.getEntity() instanceof FallingBlock && !ItemUtils.isAir(event.getTo()));

        private final String pattern;
        private final Checker<EntityChangeBlockEvent> checker;
        private static final String[] patterns;

        private ChangeEvent(String pattern, Checker<EntityChangeBlockEvent> checker) {
            this.pattern = pattern;
            this.checker = checker;
        }

        static {
            patterns = new String[ChangeEvent.values().length];
            for (int i = 0; i < patterns.length; ++i) {
                ChangeEvent.patterns[i] = ChangeEvent.values()[i].pattern;
            }
        }
    }
}

