/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.events;

import ch.njol.skript.Skript;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.util.coll.CollectionUtils;
import io.papermc.paper.event.entity.EntityMoveEvent;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerMoveEvent;
import org.eclipse.jdt.annotation.Nullable;

public class EvtMove
extends SkriptEvent {
    private static final boolean HAS_ENTITY_MOVE = Skript.classExists("io.papermc.paper.event.entity.EntityMoveEvent");
    private EntityData<?> type;
    private boolean isPlayer;

    @Override
    public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parseResult) {
        this.type = (EntityData)args[0].getSingle();
        this.isPlayer = Player.class.isAssignableFrom(this.type.getType());
        if (!HAS_ENTITY_MOVE && !this.isPlayer) {
            Skript.error("Entity move event requires Paper 1.16.5+", ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        return true;
    }

    @Override
    public boolean check(Event event) {
        EntityMoveEvent entityEvent;
        if (this.isPlayer && event instanceof PlayerMoveEvent) {
            PlayerMoveEvent playerEvent = (PlayerMoveEvent)event;
            return EvtMove.moveCheck(playerEvent.getFrom(), playerEvent.getTo());
        }
        if (HAS_ENTITY_MOVE && event instanceof EntityMoveEvent && this.type.isInstance((Entity)(entityEvent = (EntityMoveEvent)event).getEntity())) {
            return EvtMove.moveCheck(entityEvent.getFrom(), entityEvent.getTo());
        }
        return false;
    }

    @Override
    public @Nullable Class<? extends Event>[] getEventClasses() {
        if (this.isPlayer) {
            return new Class[]{PlayerMoveEvent.class};
        }
        if (HAS_ENTITY_MOVE) {
            return new Class[]{EntityMoveEvent.class};
        }
        return null;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return this.type + " move";
    }

    private static boolean moveCheck(Location from, Location to) {
        return from.getX() != to.getX() || from.getY() != to.getY() || from.getZ() != to.getZ() || from.getWorld() != to.getWorld();
    }

    static {
        Class[] events = HAS_ENTITY_MOVE ? CollectionUtils.array(PlayerMoveEvent.class, EntityMoveEvent.class) : CollectionUtils.array(PlayerMoveEvent.class);
        Skript.registerEvent("Move", EvtMove.class, events, "%entitydata% (move|walk|step)").description("Called when a player or entity moves.", "NOTE: Move event will only be called when the entity/player moves position, not orientation (ie: looking around).", "NOTE: These events can be performance heavy as they are called quite often.", "If you use these events, and later remove them, a server restart is recommended to clear registered events from Skript.").examples("on player move:", "\tif player does not have permission \"player.can.move\":", "\t\tcancel event", "on skeleton move:", "\tif event-entity is not in world \"world\":", "\t\tkill event-entity").requiredPlugins("Paper 1.16.5+ (entity move)").since("2.6");
    }
}

