/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.Inventory;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Anvil Text Input")
@Description(value={"An expression to get the name to be applied to an item in an anvil inventory."})
@Examples(value={"on inventory click:", "\ttype of event-inventory is anvil inventory", "\tif the anvil input text of the event-inventory is \"FREE OP\":", "\t\tban player"})
@Since(value="2.7")
public class ExprAnvilText
extends SimplePropertyExpression<Inventory, String> {
    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        return true;
    }

    @Override
    public @Nullable String convert(Inventory inv) {
        if (!(inv instanceof AnvilInventory)) {
            return null;
        }
        return ((AnvilInventory)inv).getRenameText();
    }

    @Override
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @Override
    public String getPropertyName() {
        return "anvil text input";
    }

    static {
        ExprAnvilText.register(ExprAnvilText.class, String.class, "anvil [inventory] (rename|text) input", "inventories");
    }
}

