/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.ServerPlatform;
import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.chat.BungeeConverter;
import ch.njol.skript.util.chat.ChatMessages;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.kyori.adventure.text.serializer.bungeecord.BungeeComponentSerializer;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Book Pages")
@Description(value={"The pages of a book (Supports Skript's chat format)", "Note: In order to modify the pages of a new written book, you must have the title and author", "of the book set. Skript will do this for you, but if you want your own, please set those values."})
@Examples(value={"on book sign:", "\tmessage \"Book Pages: %pages of event-item%\"", "\tmessage \"Book Page 1: %page 1 of event-item%\"", "", "set page 1 of player's held item to \"Book writing\""})
@Since(value="2.2-dev31, 2.7 (changers)")
public class ExprBookPages
extends SimpleExpression<String> {
    private static BungeeComponentSerializer serializer;
    private Expression<?> items;
    private @Nullable Expression<Number> page;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (matchedPattern == 0 || matchedPattern == 1) {
            this.items = exprs[0];
        } else if (matchedPattern == 2) {
            this.page = exprs[0];
            this.items = exprs[1];
        } else {
            this.items = exprs[0];
            this.page = exprs[1];
        }
        return true;
    }

    protected @Nullable String[] get(Event event) {
        ArrayList<String> pages = new ArrayList<String>();
        for (Object object : this.items.getArray(event)) {
            int page;
            BookMeta bookMeta = null;
            if (object instanceof ItemType) {
                ItemType itemType = (ItemType)object;
                if (!(itemType.getItemMeta() instanceof BookMeta)) continue;
                bookMeta = (BookMeta)itemType.getItemMeta();
            } else if (object instanceof ItemStack) {
                ItemStack itemstack = (ItemStack)object;
                if (!(itemstack.getItemMeta() instanceof BookMeta)) continue;
                bookMeta = (BookMeta)itemstack.getItemMeta();
            } else assert (false);
            if (bookMeta == null) continue;
            if (this.isAllPages()) {
                pages.addAll(bookMeta.getPages());
                continue;
            }
            Number pageNumber = this.page.getSingle(event);
            if (pageNumber == null || (page = pageNumber.intValue()) <= 0 || page > bookMeta.getPageCount()) continue;
            pages.add(bookMeta.getPage(page));
        }
        return pages.toArray(new String[0]);
    }

    @Override
    public @Nullable Class<?>[] acceptChange(Changer.ChangeMode mode) {
        switch (mode) {
            case RESET: 
            case DELETE: {
                return CollectionUtils.array(new Class[0]);
            }
            case SET: {
                return CollectionUtils.array(this.isAllPages() ? String[].class : String.class);
            }
            case ADD: {
                return this.isAllPages() ? CollectionUtils.array(String[].class) : null;
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void change(Event event, Object @Nullable [] delta, Changer.ChangeMode mode) {
        String[] newPages;
        if (delta == null && (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.ADD)) {
            return;
        }
        int page = !this.isAllPages() ? this.page.getOptionalSingle(event).orElse(-1).intValue() : -1;
        String[] stringArray = newPages = delta == null ? null : new String[delta.length];
        if (newPages != null) {
            for (int i = 0; i < delta.length; ++i) {
                newPages[i] = delta[i] + "";
            }
        }
        ?[] objArray = this.items.getArray(event);
        int n = objArray.length;
        int n2 = 0;
        while (true) {
            block27: {
                List<Object> pages;
                BookMeta bookMeta;
                Object object;
                block31: {
                    block30: {
                        block28: {
                            block29: {
                                block26: {
                                    if (n2 >= n) {
                                        return;
                                    }
                                    object = objArray[n2];
                                    bookMeta = null;
                                    if (!(object instanceof ItemType)) break block26;
                                    ItemType itemType = (ItemType)object;
                                    if (!(itemType.getItemMeta() instanceof BookMeta)) break block27;
                                    bookMeta = (BookMeta)itemType.getItemMeta();
                                    break block28;
                                }
                                if (!(object instanceof ItemStack)) break block29;
                                ItemStack itemstack = (ItemStack)object;
                                if (!(itemstack.getItemMeta() instanceof BookMeta)) break block27;
                                bookMeta = (BookMeta)itemstack.getItemMeta();
                                break block28;
                            }
                            assert (false);
                        }
                        if (bookMeta == null) break block27;
                        pages = null;
                        if (!this.isAllPages()) break block30;
                        switch (mode) {
                            case RESET: 
                            case DELETE: {
                                pages = Collections.singletonList("");
                                break block31;
                            }
                            case SET: {
                                pages = Arrays.asList(newPages);
                                break block31;
                            }
                            case ADD: {
                                pages = new ArrayList(bookMeta.getPages());
                                pages.addAll(Arrays.asList(newPages));
                                break block31;
                            }
                            default: {
                                assert (false);
                                break block31;
                            }
                        }
                    }
                    pages = new ArrayList(bookMeta.getPages());
                }
                int pageCount = bookMeta.getPageCount();
                switch (mode) {
                    case RESET: 
                    case DELETE: {
                        if (this.isAllPages()) break;
                        if (page > 0 && page <= pageCount) {
                            pages.remove(page - 1);
                            break;
                        }
                        break block27;
                    }
                    case SET: {
                        if (newPages.length == 0) break block27;
                        if (this.isAllPages()) break;
                        if (page <= 0) break block27;
                        while (pages.size() < page) {
                            pages.add("");
                        }
                        pages.set(page - 1, newPages[0]);
                    }
                }
                if (serializer != null) {
                    if (!bookMeta.hasTitle() && bookMeta.hasDisplayName()) {
                        bookMeta.title(bookMeta.displayName());
                    }
                    List components = pages.stream().map(ChatMessages::parseToArray).map(BungeeConverter::convert).map(serializer::deserialize).collect(Collectors.toList());
                    bookMeta.pages(components);
                } else {
                    bookMeta.setPages(pages);
                }
                if (!bookMeta.hasTitle()) {
                    String title = bookMeta.hasDisplayName() ? bookMeta.getDisplayName() : "Written Book";
                    bookMeta.setTitle(title);
                }
                if (!bookMeta.hasAuthor()) {
                    bookMeta.setAuthor("Server");
                }
                if (object instanceof ItemType) {
                    ((ItemType)object).setItemMeta((ItemMeta)bookMeta);
                } else if (object instanceof ItemStack) {
                    ((ItemStack)object).setItemMeta((ItemMeta)bookMeta);
                }
            }
            ++n2;
        }
    }

    private boolean isAllPages() {
        return this.page == null;
    }

    @Override
    public boolean isSingle() {
        return this.items.isSingle() && !this.isAllPages();
    }

    @Override
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @Override
    public String toString(@Nullable Event event, boolean debug) {
        return (this.page != null ? "page " + this.page.toString(event, debug) : "book pages") + " of " + this.items.toString(event, debug);
    }

    static {
        Skript.registerExpression(ExprBookPages.class, String.class, ExpressionType.PROPERTY, "[all [[of] the]|the] [book] (pages|content) of %itemtypes/itemstacks%", "%itemtypes/itemstacks%'[s] [book] (pages|content)", "[book] page %number% of %itemtypes/itemstacks%", "%itemtypes/itemstacks%'[s] [book] page %number%");
        if (Skript.isRunningMinecraft(1, 16) && Skript.getServerPlatform() == ServerPlatform.BUKKIT_PAPER) {
            serializer = BungeeComponentSerializer.get();
        }
    }
}

