/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Custom Chest Inventory")
@Description(value={"Returns a chest inventory with the given amount of rows and the name. Use the <a href=effects.html#EffOpenInventory>open inventory</a> effect to open it."})
@Examples(value={"open chest inventory with 1 row named \"test\" to player", "set {_inventory} to chest inventory with 1 row"})
@Since(value="2.2-dev34")
public class ExprChestInventory
extends SimpleExpression<Inventory> {
    private static final String DEFAULT_CHEST_TITLE;
    private static final int DEFAULT_CHEST_ROWS;
    private @Nullable Expression<Number> rows;
    private @Nullable Expression<String> name;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.name = exprs[matchedPattern];
        this.rows = exprs[matchedPattern ^ 1];
        return true;
    }

    protected Inventory[] get(Event e) {
        String name = this.name != null ? this.name.getSingle(e) : DEFAULT_CHEST_TITLE;
        Integer rows = this.rows != null ? (Number)this.rows.getSingle(e) : (Number)DEFAULT_CHEST_ROWS;
        rows = rows == null ? Integer.valueOf(DEFAULT_CHEST_ROWS) : rows;
        name = name == null ? DEFAULT_CHEST_TITLE : name;
        int size = rows * 9;
        if (size % 9 != 0) {
            size = 27;
        }
        if (size < 0) {
            size = 0;
        }
        if (size > 54) {
            size = 54;
        }
        return CollectionUtils.array(Bukkit.createInventory(null, (int)size, (String)name));
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public Class<? extends Inventory> getReturnType() {
        return Inventory.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "chest inventory named " + (this.name != null ? this.name.toString(e, debug) : "\"" + DEFAULT_CHEST_TITLE + "\"") + " with " + (this.rows != null ? this.rows.toString(e, debug) : "" + DEFAULT_CHEST_ROWS + " rows");
    }

    static {
        Skript.registerExpression(ExprChestInventory.class, Inventory.class, ExpressionType.COMBINED, "[a] [new] chest inventory (named|with name) %string% [with %-number% row[s]]", "[a] [new] chest inventory with %number% row[s] [(named|with name) %-string%]");
        DEFAULT_CHEST_TITLE = InventoryType.CHEST.getDefaultTitle();
        DEFAULT_CHEST_ROWS = InventoryType.CHEST.getDefaultSize() / 9;
    }
}

