/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.LiteralUtils;
import ch.njol.util.Kleenean;
import ch.njol.util.StringUtils;
import ch.njol.util.coll.CollectionUtils;
import com.google.common.collect.Iterators;
import java.lang.reflect.Array;
import java.util.Iterator;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Element of")
@Description(value={"The first, last or a random element of a set, e.g. a list variable.", "See also: <a href='#ExprRandom'>random</a>"})
@Examples(value={"give a random element out of {free items::*} to the player"})
@Since(value="2.0, 2.7 (relative to last element)")
public class ExprElement
extends SimpleExpression<Object> {
    private ElementType type;
    private Expression<?> expr;
    private @Nullable Expression<Number> number;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.expr = LiteralUtils.defendExpression(exprs[2]);
        this.type = ElementType.values()[parseResult.mark];
        this.number = this.type == ElementType.ORDINAL ? exprs[0] : exprs[1];
        return LiteralUtils.canInitSafely(this.expr);
    }

    @Override
    protected @Nullable Object[] get(Event event) {
        Iterator<?> iter = this.expr.iterator(event);
        if (iter == null || !iter.hasNext()) {
            return null;
        }
        Object element = null;
        switch (this.type) {
            case FIRST: {
                element = iter.next();
                break;
            }
            case LAST: {
                element = Iterators.getLast(iter);
                break;
            }
            case ORDINAL: {
                assert (this.number != null);
                Number number = this.number.getSingle(event);
                if (number == null) {
                    return null;
                }
                try {
                    element = Iterators.get(iter, (int)(number.intValue() - 1));
                    break;
                }
                catch (IndexOutOfBoundsException exception) {
                    return null;
                }
            }
            case RANDOM: {
                Object[] allIterValues = Iterators.toArray(iter, Object.class);
                element = CollectionUtils.getRandom(allIterValues);
                break;
            }
            case TAIL_END_ORDINAL: {
                Object[] allIterValues = Iterators.toArray(iter, Object.class);
                assert (this.number != null);
                Number number = this.number.getSingle(event);
                if (number == null) {
                    return null;
                }
                int ordinal = number.intValue();
                if (ordinal <= 0 || ordinal > allIterValues.length) {
                    return null;
                }
                element = allIterValues[allIterValues.length - ordinal];
            }
        }
        Object[] elementArray = (Object[])Array.newInstance(this.getReturnType(), 1);
        elementArray[0] = element;
        return elementArray;
    }

    @Override
    public <R> @Nullable Expression<? extends R> getConvertedExpression(Class<R> ... to) {
        Expression<R> convExpr = this.expr.getConvertedExpression(to);
        if (convExpr == null) {
            return null;
        }
        ExprElement exprElement = new ExprElement();
        exprElement.type = this.type;
        exprElement.expr = convExpr;
        exprElement.number = this.number;
        return exprElement;
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public Class<?> getReturnType() {
        return this.expr.getReturnType();
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        String prefix;
        switch (this.type) {
            case FIRST: {
                prefix = "the first";
                break;
            }
            case LAST: {
                prefix = "the last";
                break;
            }
            case RANDOM: {
                prefix = "a random";
                break;
            }
            case ORDINAL: {
                assert (this.number != null);
                prefix = "the ";
                if (this.number instanceof Literal) {
                    Number number = (Number)((Literal)this.number).getSingle();
                    if (number == null) {
                        prefix = prefix + this.number.toString(e, debug) + "th";
                        break;
                    }
                    prefix = prefix + StringUtils.fancyOrderNumber(number.intValue());
                    break;
                }
                prefix = prefix + this.number.toString(e, debug) + "th";
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return prefix + " element of " + this.expr.toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprElement.class, Object.class, ExpressionType.PROPERTY, "(0:[the] first|1:[the] last|2:[a] random|3:[the] %-number%(st|nd|rd|th)|4:[the] %-number%(st|nd|rd|th) [to] last) element [out] of %objects%");
    }

    private static enum ElementType {
        FIRST,
        LAST,
        RANDOM,
        ORDINAL,
        TAIL_END_ORDINAL;

    }
}

