/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Events;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.events.bukkit.ExperienceSpawnEvent;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.Experience;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerExpChangeEvent;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Experience")
@Description(value={"How much experience was spawned in an experience spawn or block break event. Can be changed."})
@Examples(value={"on experience spawn:", "\tadd 5 to the spawned experience", "on break of coal ore:", "\tclear dropped experience", "on break of diamond ore:", "\tif tool of player = diamond pickaxe:", "\t\tadd 100 to dropped experience"})
@Since(value="2.1, 2.5.3 (block break event), 2.7 (experience change event)")
@Events(value={"experience spawn", "break / mine", "experience change"})
public class ExprExperience
extends SimpleExpression<Experience> {
    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!this.getParser().isCurrentEvent(ExperienceSpawnEvent.class, BlockBreakEvent.class, PlayerExpChangeEvent.class)) {
            Skript.error("The experience expression can only be used in experience spawn, block break and player experience change events");
            return false;
        }
        return true;
    }

    protected @Nullable Experience[] get(Event e) {
        if (e instanceof ExperienceSpawnEvent) {
            return new Experience[]{new Experience(((ExperienceSpawnEvent)e).getSpawnedXP())};
        }
        if (e instanceof BlockBreakEvent) {
            return new Experience[]{new Experience(((BlockBreakEvent)e).getExpToDrop())};
        }
        if (e instanceof PlayerExpChangeEvent) {
            return new Experience[]{new Experience(((PlayerExpChangeEvent)e).getAmount())};
        }
        return new Experience[0];
    }

    @Override
    public @Nullable Class<?>[] acceptChange(Changer.ChangeMode mode) {
        switch (mode) {
            case ADD: 
            case DELETE: 
            case REMOVE: 
            case REMOVE_ALL: {
                return new Class[]{Experience[].class, Number[].class};
            }
            case SET: {
                return new Class[]{Experience.class, Number.class};
            }
            case RESET: {
                return null;
            }
        }
        return null;
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        double eventExp;
        if (e instanceof ExperienceSpawnEvent) {
            eventExp = ((ExperienceSpawnEvent)e).getSpawnedXP();
        } else if (e instanceof BlockBreakEvent) {
            eventExp = ((BlockBreakEvent)e).getExpToDrop();
        } else if (e instanceof PlayerExpChangeEvent) {
            eventExp = ((PlayerExpChangeEvent)e).getAmount();
        } else {
            return;
        }
        if (delta == null) {
            eventExp = 0.0;
        } else {
            block6: for (Object obj : delta) {
                double value = obj instanceof Experience ? (double)((Experience)obj).getXP() : ((Number)obj).doubleValue();
                switch (mode) {
                    case ADD: {
                        eventExp += value;
                        continue block6;
                    }
                    case SET: {
                        eventExp = value;
                        continue block6;
                    }
                    case REMOVE: 
                    case REMOVE_ALL: {
                        eventExp -= value;
                        continue block6;
                    }
                    case DELETE: 
                    case RESET: {
                        assert (false);
                        continue block6;
                    }
                }
            }
        }
        eventExp = Math.max(0L, Math.round(eventExp));
        int roundedEventExp = (int)eventExp;
        if (e instanceof ExperienceSpawnEvent) {
            ((ExperienceSpawnEvent)e).setSpawnedXP(roundedEventExp);
        } else if (e instanceof BlockBreakEvent) {
            ((BlockBreakEvent)e).setExpToDrop(roundedEventExp);
        } else if (e instanceof PlayerExpChangeEvent) {
            ((PlayerExpChangeEvent)e).setAmount(roundedEventExp);
        }
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public Class<? extends Experience> getReturnType() {
        return Experience.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "the experience";
    }

    static {
        Skript.registerExpression(ExprExperience.class, Experience.class, ExpressionType.SIMPLE, "[the] (spawned|dropped|) [e]xp[erience] [orb[s]]");
    }
}

