/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.util.Timespan;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Entity Fire Burn Duration")
@Description(value={"How much time an entity will be burning for."})
@Examples(value={"send \"You will stop burning in %fire time of player%\""})
@Since(value="2.7")
public class ExprFireTicks
extends SimplePropertyExpression<Entity, Timespan> {
    @Override
    public @Nullable Timespan convert(Entity entity) {
        return Timespan.fromTicks_i(Math.max(entity.getFireTicks(), 0));
    }

    @Override
    public @Nullable Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return mode != Changer.ChangeMode.REMOVE_ALL ? CollectionUtils.array(Timespan.class) : null;
    }

    @Override
    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Entity[] entities = (Entity[])this.getExpr().getArray(event);
        int change = delta == null ? 0 : (int)((Timespan)delta[0]).getTicks_i();
        switch (mode) {
            case REMOVE: {
                change = -change;
            }
            case ADD: {
                for (Entity entity : entities) {
                    entity.setFireTicks(entity.getFireTicks() + change);
                }
                break;
            }
            case DELETE: 
            case RESET: 
            case SET: {
                for (Entity entity : entities) {
                    entity.setFireTicks(change);
                }
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    @Override
    public Class<? extends Timespan> getReturnType() {
        return Timespan.class;
    }

    @Override
    protected String getPropertyName() {
        return "fire time";
    }

    static {
        ExprFireTicks.register(ExprFireTicks.class, Timespan.class, "(burn[ing]|fire) (time|duration)", "entities");
    }
}

