/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptConfig;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.StringUtils;
import java.util.regex.Pattern;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Join & Split")
@Description(value={"Joins several texts with a common delimiter (e.g. \", \"), or splits a text into multiple texts at a given delimiter."})
@Examples(value={"message \"Online players: %join all players with \"\" | \"\"%\" # %all players% would use the default \"x, y, and z\"", "set {_s::*} to the string argument split at \",\""})
@Since(value="2.1, 2.5.2 (regex support), 2.7 (case sensitivity)")
public class ExprJoinSplit
extends SimpleExpression<String> {
    private boolean join;
    private boolean regex;
    private boolean caseSensitivity;
    private Expression<String> strings;
    private @Nullable Expression<String> delimiter;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.join = matchedPattern == 0;
        this.regex = matchedPattern >= 3;
        this.caseSensitivity = SkriptConfig.caseSensitive.value() != false || parseResult.hasTag("case");
        this.strings = exprs[0];
        this.delimiter = exprs[1];
        return true;
    }

    protected @Nullable String[] get(Event event) {
        String delimiter;
        Object[] strings = this.strings.getArray(event);
        String string = delimiter = this.delimiter != null ? this.delimiter.getSingle(event) : "";
        if (strings.length == 0 || delimiter == null) {
            return new String[0];
        }
        if (this.join) {
            return new String[]{StringUtils.join(strings, delimiter)};
        }
        return strings[0].split(this.regex ? delimiter : (this.caseSensitivity ? "" : "(?i)") + Pattern.quote(delimiter), -1);
    }

    @Override
    public boolean isSingle() {
        return this.join;
    }

    @Override
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @Override
    public String toString(@Nullable Event event, boolean debug) {
        if (this.join) {
            return "join " + this.strings.toString(event, debug) + (this.delimiter != null ? " with " + this.delimiter.toString(event, debug) : "");
        }
        return (this.regex ? "regex " : "") + "split " + this.strings.toString(event, debug) + (this.delimiter != null ? " at " + this.delimiter.toString(event, debug) : "") + (this.regex ? "" : "(case sensitive: " + this.caseSensitivity + ")");
    }

    static {
        Skript.registerExpression(ExprJoinSplit.class, String.class, ExpressionType.COMBINED, "(concat[enate]|join) %strings% [(with|using|by) [[the] delimiter] %-string%]", "split %string% (at|using|by) [[the] delimiter] %string% [case:with case sensitivity]", "%string% split (at|using|by) [[the] delimiter] %string% [case:with case sensitivity]", "regex split %string% (at|using|by) [[the] delimiter] %string%", "regex %string% split (at|using|by) [[the] delimiter] %string%");
    }
}

