/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang;

import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionList;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.util.SimpleLiteral;
import ch.njol.skript.util.Utils;
import java.lang.reflect.Array;
import org.eclipse.jdt.annotation.Nullable;

public class LiteralList<T>
extends ExpressionList<T>
implements Literal<T> {
    public LiteralList(Literal<? extends T>[] literals, Class<T> returnType, boolean and) {
        super(literals, returnType, and);
    }

    public LiteralList(Literal<? extends T>[] literals, Class<T> returnType, boolean and, LiteralList<?> source) {
        super(literals, returnType, and, source);
    }

    @Override
    public T[] getArray() {
        return this.getArray(null);
    }

    @Override
    public T getSingle() {
        return this.getSingle(null);
    }

    @Override
    public T[] getAll() {
        return this.getAll(null);
    }

    @Override
    public <R> @Nullable Literal<? extends R> getConvertedExpression(Class<R> ... to) {
        Literal[] exprs = new Literal[this.expressions.length];
        Class[] classes = new Class[this.expressions.length];
        for (int i = 0; i < exprs.length; ++i) {
            exprs[i] = (Literal)this.expressions[i].getConvertedExpression(to);
            if (exprs[i] == null) {
                return null;
            }
            classes[i] = exprs[i].getReturnType();
        }
        return new LiteralList(exprs, Utils.getSuperType(classes), this.and, this);
    }

    public Literal<? extends T>[] getExpressions() {
        return (Literal[])super.getExpressions();
    }

    @Override
    public Expression<T> simplify() {
        boolean isSimpleList = true;
        for (int i = 0; i < this.expressions.length; ++i) {
            isSimpleList &= this.expressions[i].isSingle();
        }
        if (isSimpleList) {
            Object[] values = (Object[])Array.newInstance(this.getReturnType(), this.expressions.length);
            for (int i = 0; i < values.length; ++i) {
                values[i] = ((Literal)this.expressions[i]).getSingle();
            }
            return new SimpleLiteral<Object>(values, this.getReturnType(), this.and);
        }
        return this;
    }
}

